/*
 * Decompiled with CFR 0.152.
 */
package decider.play;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import decider.play.Scene;
import net.beadsproject.beads.core.UGen;

public class XScene
implements Scene {
    private static final long serialVersionUID = 1L;
    public static final int DIVISIONS = 20;
    private Decider decider;
    private String name;
    private float richterScale;
    private boolean[][] state;
    private final DeciderSoundEvent[] events;

    public XScene(DeciderSoundEvent[] events) {
        this.events = events;
        this.state = new boolean[events.length][20];
        for (int i = 0; i < 20; ++i) {
            this.state[0][i] = true;
        }
    }

    @Override
    public void dispose() {
        for (DeciderSoundEvent event : this.events) {
            event.destroy();
        }
    }

    @Override
    public void tick(float tempo, int tickCount) {
        if (this.events != null) {
            for (DeciderSoundEvent event : this.events) {
                if (event == null) continue;
                event.tick(tempo, tickCount);
            }
        }
    }

    @Override
    public void process(UGen output) {
        if (this.decider != null) {
            this.decider.process();
            float fract = (float)this.decider.getCurrentLeaf() / (float)this.decider.getNumLeaves();
            int index = (int)(fract * 20.0f);
            for (int i = 0; i < this.state.length; ++i) {
                if (!this.state[i][index]) continue;
                DeciderSoundEvent myEvent = this.events[i];
                myEvent.play(output, this.decider.getCurrentLeaf(), this.decider);
            }
        }
    }

    public boolean[][] getStateArray() {
        return this.state;
    }

    @Override
    public void setInputFract(int i, float f) {
        this.decider.setInputFract(i, f);
    }

    @Override
    public void setDecider(Decider d) {
        this.decider = d;
    }

    @Override
    public Decider getDecider() {
        return this.decider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public float getRichterScale() {
        return this.richterScale;
    }

    public void setRichterScale(float richterScale) {
        this.richterScale = richterScale;
    }
}

