/*
 * Decompiled with CFR 0.152.
 */
package isea2015;

import de.sciss.net.OSCMessage;
import decider.core.Decider;
import decider.play.DeciderAgent;
import decider.play.DeciderSoundEvent;
import decider.play.XScene;
import isea2015.sound_events.StewKitSoundEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javafx.application.Application;
import javafx.stage.Stage;
import net.beadsproject.beads.analysis.featureextractors.Frequency;
import net.beadsproject.beads.analysis.featureextractors.MFCC;
import net.beadsproject.beads.analysis.featureextractors.Power;
import net.beadsproject.beads.analysis.featureextractors.SpectralCentroid;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.AudioInputGUI;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;
import net.beadsproject.beads.ugens.WavePlayer;
import org.jaudiolibs.beads.AudioServerIO;
import org.musicalmetacreation.musebot.tools.MusebotAssistant;

public class OBJazzDrumBot
extends Application
implements MusebotAssistant.Responder {
    private static final Logger log = Logger.getLogger(OBJazzDrumBot.class.getName());
    public static final String workingDir;
    public static final String resDir;
    public static final String audioDir;
    MusebotAssistant assistant;
    AudioContext ac;
    UGen in;
    Envelope gainEnv;
    Envelope masterGainEnv;
    Glide tempoCtrl;
    Gain masterGain;
    ArrayList<int[]> chords;
    ArrayList<Integer> chordDurations;
    int phraselength;
    Map<Integer, int[]> chordSeq;
    int[] tala;
    int measure;
    int[] currentChord;
    DeciderAgent agent;

    public static void main(String[] args) {
        OBJazzDrumBot.launch((String[])args);
    }

    public void start(Stage primaryStage) throws URISyntaxException {
        log.info("Creating musebot");
        this.assistant = new MusebotAssistant();
        this.assistant.setPrintMessage(true);
        this.ac = new AudioContext(new AudioServerIO.Jack(), 512);
        this.in = this.ac.getAudioInput(new int[]{1, 2});
        this.gainEnv = new Envelope(this.ac, 4.0f);
        Gain g = new Gain(this.ac, 2, this.gainEnv);
        this.masterGainEnv = new Envelope(this.ac, 1.0f);
        this.masterGain = new Gain(this.ac, 2, this.masterGainEnv);
        this.masterGain.addInput(g);
        this.ac.out.addInput(this.masterGain);
        this.tempoCtrl = new Glide(this.ac, 2.0f, 120.0f);
        this.setupDecider();
        this.ac.start();
        this.assistant.respondWith(this);
    }

    private void sound(UGen sound) {
        this.masterGain.addInput(sound);
    }

    private void feedbackTest() {
        TapIn tin = new TapIn(this.ac, 5000.0f);
        TapOut tout = new TapOut(this.ac, tin, 1000.0f);
        this.ac.out.addInput(tout);
        tin.addInput(this.in);
    }

    private void setupDecider() {
        StewKitSoundEvent event = new StewKitSoundEvent();
        event.init();
        XScene s = new XScene(new DeciderSoundEvent[]{event});
        Decider d = null;
        try {
            FileInputStream fis = new FileInputStream(new File(System.getProperty("user.dir") + "/resources/deciders/jazzdrum_decider2"));
            ObjectInputStream ois = new ObjectInputStream(fis);
            d = (Decider)ois.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        d.setConsolidate(true);
        s.setDecider(d);
        s.getDecider().centerState();
        ArrayList extractors = new ArrayList();
        extractors.add(SpectralCentroid.class);
        extractors.add(Frequency.class);
        extractors.add(Power.class);
        extractors.add(MFCC.class);
        AudioInputGUI newGoo = AudioInputGUI.createAndShow(this.ac, extractors);
        this.agent = new DeciderAgent(s, this.masterGain, newGoo.getAnalyzer());
    }

    private void bleep() {
        WavePlayer wp = new WavePlayer(this.ac, 500.0f, Buffer.SINE);
        Envelope e = new Envelope(this.ac, 1.0f);
        Gain g = new Gain(this.ac, 2, e);
        g.addInput(wp);
        this.sound(g);
        e.addSegment(0.0f, 100.0f, new KillTrigger(g));
    }

    @Override
    public void incoming(OSCMessage msg) {
        switch (msg.getName()) {
            case "/broadcast/plan/chord": {
                this.chords = new ArrayList();
                for (int i = 0; i < msg.getArgCount(); ++i) {
                    String[] s = ((String)msg.getArg(i)).split("[ ]");
                    int[] notes = new int[3];
                    for (int j = 0; j < 3; ++j) {
                        notes[j] = Integer.parseInt(s[j]);
                        log.info("" + j + " : " + notes[j]);
                    }
                    this.chords.add(notes);
                }
                break;
            }
            case "/broadcast/plan/chordDuration": {
                this.chordDurations = new ArrayList();
                String[] parts = ((String)msg.getArg(0)).split("[ ]");
                for (int i = 0; i < parts.length; ++i) {
                    this.chordDurations.add(Integer.parseInt(parts[i]));
                }
                break;
            }
            case "/broadcast/plan/phraselength": {
                this.phraselength = (Integer)msg.getArg(0);
                break;
            }
            case "/broadcast/plan/tala": {
                break;
            }
        }
    }

    @Override
    public void time(float tempo, int tickCount) {
        log.info("Time message: " + tickCount + " (" + tempo + " bpm)");
        this.tempoCtrl.setValue(tempo);
        this.agent.tick(tempo, tickCount);
    }

    @Override
    public void gain(float level, float time) {
        this.masterGainEnv.kill();
    }

    @Override
    public void kill() {
        this.masterGainEnv.lock(false);
        this.masterGainEnv.addSegment(0.0f, 4000.0f, new Bead(){

            @Override
            protected void messageReceived(Bead message) {
                super.messageReceived(message);
                System.exit(0);
            }
        });
        this.masterGainEnv.lock(true);
    }

    static {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        log.addHandler(handler);
        handler.setLevel(Level.ALL);
        log.setLevel(Level.ALL);
        workingDir = System.getProperty("user.dir");
        resDir = workingDir + "/resources";
        audioDir = resDir + "/audio";
    }
}

