/*
 * Decompiled with CFR 0.152.
 */
package isea2015;

import de.sciss.net.OSCMessage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javafx.application.Application;
import javafx.stage.Stage;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;
import net.beadsproject.beads.ugens.WavePlayer;
import org.jaudiolibs.beads.AudioServerIO;
import org.musicalmetacreation.musebot.tools.MusebotAssistant;

public class OBMelodySoloBot
extends Application
implements MusebotAssistant.Responder {
    private static final Logger log = Logger.getLogger(OBMelodySoloBot.class.getName());
    public static final String workingDir;
    public static final String resDir;
    public static final String audioDir;
    MusebotAssistant assistant;
    AudioContext ac;
    UGen in;
    Sample s;
    SamplePlayer gsp;
    Envelope gainEnv;
    Envelope masterGainEnv;
    Glide tempoCtrl;
    Gain masterGain;
    ArrayList<int[]> chords;
    ArrayList<Integer> chordDurations;
    int phraselength;
    Map<Integer, int[]> chordSeq;
    int[] tala;
    int measure;
    int[] currentChord;
    String filename = audioDir + "/blipcool.aiff";

    public static void main(String[] args) {
        OBMelodySoloBot.launch((String[])args);
    }

    public void start(Stage primaryStage) throws URISyntaxException {
        this.assistant = new MusebotAssistant();
        this.ac = new AudioContext(new AudioServerIO.Jack(), 512);
        this.in = this.ac.getAudioInput(new int[]{1, 2});
        log.info("Creating musebot");
        try {
            Sample sample = new Sample(this.filename);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.s = SampleManager.sample(this.filename);
        this.gsp = new SamplePlayer(this.ac, this.s);
        this.gainEnv = new Envelope(this.ac, 4.0f);
        Gain g = new Gain(this.ac, 2, this.gainEnv);
        this.masterGainEnv = new Envelope(this.ac, 1.0f);
        this.masterGain = new Gain(this.ac, 2, this.masterGainEnv);
        g.addInput(this.gsp);
        this.masterGain.addInput(g);
        this.ac.out.addInput(this.masterGain);
        this.tempoCtrl = new Glide(this.ac, 120.0f, 2.0f);
        double sampleLengthBeats = 16.0;
        final float initialTempo = (float)(sampleLengthBeats / (this.s.getLength() / 60000.0));
        System.out.println("Length=" + this.s.getLength());
        log.info("Initial tempo derived from sample is " + initialTempo);
        this.gsp.setRate(new Function((UGen)this.tempoCtrl){

            @Override
            public float calculate() {
                float newRate = this.x[0] / initialTempo;
                return newRate;
            }
        });
        this.gsp.setKillOnEnd(false);
        this.ac.start();
        this.assistant.respondWith(this);
        this.assistant.setPrintMessage(true);
    }

    private void sound(UGen sound) {
        this.masterGain.addInput(sound);
    }

    private void feedbackTest() {
        TapIn tin = new TapIn(this.ac, 5000.0f);
        TapOut tout = new TapOut(this.ac, tin, 1000.0f);
        this.ac.out.addInput(tout);
        tin.addInput(this.in);
    }

    private void bleep() {
        WavePlayer wp = new WavePlayer(this.ac, 500.0f, Buffer.SINE);
        Envelope e = new Envelope(this.ac, 1.0f);
        Gain g = new Gain(this.ac, 2, e);
        g.addInput(wp);
        this.sound(g);
        e.addSegment(0.0f, 100.0f, new KillTrigger(g));
    }

    @Override
    public void incoming(OSCMessage msg) {
        switch (msg.getName()) {
            case "/broadcast/plan/chord": {
                this.chords = new ArrayList();
                for (int i = 0; i < msg.getArgCount(); ++i) {
                    String[] s = ((String)msg.getArg(i)).split("[ ]");
                    int[] notes = new int[3];
                    for (int j = 0; j < 3; ++j) {
                        notes[j] = Integer.parseInt(s[j]);
                        log.info("" + j + " : " + notes[j]);
                    }
                    this.chords.add(notes);
                }
                break;
            }
            case "/broadcast/plan/chordDuration": {
                this.chordDurations = new ArrayList();
                for (int i = 0; i < msg.getArgCount(); ++i) {
                    this.chordDurations.add((Integer)msg.getArg(i));
                }
                break;
            }
            case "/broadcast/plan/phraselength": {
                this.phraselength = (Integer)msg.getArg(0);
                break;
            }
            case "/broadcast/plan/tala": {
                break;
            }
        }
    }

    private void recalculateChords() {
        if (this.chordDurations == null || this.chords == null || this.phraselength == -1) {
            return;
        }
        int totalDurations = 0;
        for (int i = 0; i < this.chordDurations.size(); ++i) {
            totalDurations += this.chordDurations.get(i).intValue();
        }
        this.chordSeq = new HashMap<Integer, int[]>();
        int nextStartTime = 0;
        for (int i = 0; i < this.chords.size(); ++i) {
            this.chordSeq.put(nextStartTime, this.chords.get(i));
            nextStartTime += this.phraselength * this.chordDurations.get(i);
        }
        this.chordDurations = null;
        this.chords = null;
        this.phraselength = -1;
    }

    @Override
    public void time(float tempo, int tickCount) {
        this.tempoCtrl.setValue(tempo);
        if (tickCount % 64 == 0) {
            this.gsp.setPosition(0.0);
            this.bleep();
        }
    }

    @Override
    public void gain(float level, float time) {
        this.masterGainEnv.kill();
    }

    @Override
    public void kill() {
        this.masterGainEnv.lock(false);
        this.masterGainEnv.addSegment(0.0f, 4000.0f, new Bead(){

            @Override
            protected void messageReceived(Bead message) {
                super.messageReceived(message);
                System.exit(0);
            }
        });
        this.masterGainEnv.lock(true);
    }

    static {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        log.addHandler(handler);
        handler.setLevel(Level.ALL);
        log.setLevel(Level.ALL);
        workingDir = System.getProperty("user.dir");
        resDir = workingDir + "/resources";
        audioDir = resDir + "/audio";
    }
}

