/*
 * Decompiled with CFR 0.152.
 */
package isea2015;

import de.sciss.net.OSCMessage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javafx.application.Application;
import javafx.stage.Stage;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;
import net.beadsproject.beads.ugens.WavePlayer;
import org.jaudiolibs.beads.AudioServerIO;
import org.musicalmetacreation.musebot.tools.MusebotAssistant;

public class OBMusebotTemplate
extends Application
implements MusebotAssistant.Responder {
    private static final Logger log = Logger.getLogger(OBMusebotTemplate.class.getName());
    public static final String workingDir;
    public static final String resDir;
    public static final String audioDir;
    MusebotAssistant assistant;
    AudioContext ac;
    UGen in;
    Sample s;
    SamplePlayer gsp;
    Envelope gainEnv;
    Envelope masterGainEnv;
    Glide tempoCtrl;
    Gain masterGain;
    String filename = audioDir + "/blipcool.aiff";

    public static void main(String[] args) {
        OBMusebotTemplate.launch((String[])args);
    }

    public void start(Stage primaryStage) throws URISyntaxException {
        this.assistant = new MusebotAssistant();
        this.ac = new AudioContext(new AudioServerIO.Jack(), 512);
        this.in = this.ac.getAudioInput(new int[]{1, 2});
        log.info("Creating musebot");
        try {
            Sample sample = new Sample(this.filename);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.s = SampleManager.sample(this.filename);
        this.gsp = new SamplePlayer(this.ac, this.s);
        this.gainEnv = new Envelope(this.ac, 4.0f);
        Gain g = new Gain(this.ac, 2, this.gainEnv);
        this.masterGainEnv = new Envelope(this.ac, 1.0f);
        this.masterGain = new Gain(this.ac, 2, this.masterGainEnv);
        g.addInput(this.gsp);
        this.masterGain.addInput(g);
        this.ac.out.addInput(this.masterGain);
        this.tempoCtrl = new Glide(this.ac, 2.0f, 120.0f);
        double sampleLengthBeats = 1024.0;
        final float initialTempo = (float)(sampleLengthBeats / (this.s.getLength() / 1000.0));
        System.out.println("Length=" + this.s.getLength());
        log.info("Initial tempo derived from sample is " + initialTempo);
        this.gsp.setRate(new Function((UGen)this.tempoCtrl){

            @Override
            public float calculate() {
                float newRate = this.x[0] / initialTempo;
                return newRate;
            }
        });
        this.gsp.setKillOnEnd(false);
        this.ac.start();
        this.assistant.respondWith(this);
    }

    private void sound(UGen sound) {
        this.masterGain.addInput(sound);
    }

    private void feedbackTest() {
        TapIn tin = new TapIn(this.ac, 5000.0f);
        TapOut tout = new TapOut(this.ac, tin, 1000.0f);
        this.ac.out.addInput(tout);
        tin.addInput(this.in);
    }

    private void bleep() {
        WavePlayer wp = new WavePlayer(this.ac, 500.0f, Buffer.SINE);
        Envelope e = new Envelope(this.ac, 1.0f);
        Gain g = new Gain(this.ac, 2, e);
        g.addInput(wp);
        this.sound(g);
        e.addSegment(0.0f, 100.0f, new KillTrigger(g));
    }

    @Override
    public void incoming(OSCMessage msg) {
        log.info(msg.getName());
    }

    @Override
    public void time(float tempo, int tickCount) {
        log.info("Time message: " + tickCount + " (" + tempo + " bpm)");
        this.tempoCtrl.setValue(tempo);
        if (tickCount % 64 == 0) {
            this.gsp.setPosition(0.0);
            this.bleep();
        }
    }

    @Override
    public void gain(float level, float time) {
        this.masterGainEnv.kill();
    }

    @Override
    public void kill() {
        this.masterGainEnv.lock(false);
        this.masterGainEnv.addSegment(0.0f, 4000.0f, new Bead(){

            @Override
            protected void messageReceived(Bead message) {
                super.messageReceived(message);
                System.exit(0);
            }
        });
        this.masterGainEnv.lock(true);
    }

    static {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        log.addHandler(handler);
        handler.setLevel(Level.ALL);
        log.setLevel(Level.ALL);
        workingDir = System.getProperty("user.dir");
        resDir = workingDir + "/resources";
        audioDir = resDir + "/audio";
    }
}

