/*
 * Decompiled with CFR 0.152.
 */
package isea2015.sound_events;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.PolyLimit;
import net.beadsproject.beads.ugens.SamplePlayer;

public class StewKitSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    int lastIndex;
    int count;
    PolyLimit pl;
    Glide loopLen;
    Glide rate;
    Decider decider;
    AudioContext ac;
    int eventIndex = -1;

    @Override
    public void init() {
        String resourcesDir = System.getProperty("user.dir") + "/resources";
        SampleManager.group("stu", resourcesDir + "/audio/oboe");
        SampleManager.addToGroup("stu", SampleManager.group("", resourcesDir + "/audio/abstract"));
        SampleManager.addToGroup("stu", SampleManager.group("", resourcesDir + "/audio/Tuba sorted/Tuba Long"));
        SampleManager.addToGroup("stu", SampleManager.group("", resourcesDir + "/audio/wisper"));
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        int step;
        this.decider = decider;
        UGen result = null;
        this.ac = output.getContext();
        if (this.pl == null) {
            this.pl = new PolyLimit(this.ac, 2, 15);
            this.pl.setSteal(true);
            if (staticGain == null) {
                staticGain = new Slider(this.ac, "", 0.0f, 2.0f, 1.0f);
            }
            Gain main = new Gain(this.ac, 2, staticGain);
            main.addInput(this.pl);
            output.addInput(main);
            this.loopLen = new Glide(this.ac, 0.0f);
            this.rate = new Glide(this.ac, 1.0f, 5000.0f);
        }
        int next = 0;
        if (this.count % (step = (int)(decider.getStateFract(next++) * 500.0f + 10.0f)) == 0 || thisIndex != this.lastIndex) {
            this.eventIndex = thisIndex;
        }
        ++this.count;
        this.lastIndex = thisIndex;
        return result;
    }

    private void sound() {
        System.out.println("Sound");
        int next = 1;
        int step = (int)(this.decider.getStateFract(next++) * 500.0f + 10.0f);
        SamplePlayer sp = new SamplePlayer(this.ac, SampleManager.fromGroup("stu", this.eventIndex));
        sp.setPosition(this.decider.getRng().nextInt(300));
        int n = next++;
        if (this.decider.getStateFract(n) < 0.5f) {
            sp.setLoopType(SamplePlayer.LoopType.LOOP_ALTERNATING);
        }
        final float len = (float)sp.getSample().getLength();
        Function f = new Function((UGen)this.loopLen){

            @Override
            public float calculate() {
                return len * 0.8f * (1.0f - this.x[0]) + 0.1f;
            }
        };
        final float baseRate = (float)Math.pow(2.0, (int)(this.decider.getStateFract(next++) * 4.0f));
        Function f2 = new Function((UGen)this.rate){

            @Override
            public float calculate() {
                return baseRate * this.x[0];
            }
        };
        sp.setRate(f2);
        sp.setLoopStart(f);
        sp.setInterpolationType(SamplePlayer.InterpolationType.CUBIC);
        sp.getLoopEndUGen().setValue(len * (0.5f + this.decider.getStateFract(next++)));
        Envelope e = new Envelope(this.ac, 0.0f);
        float level = this.decider.getStateFract(next++) * 1.0f + 0.3f;
        Gain g = new Gain(this.ac, 2, e);
        int n2 = next++;
        if (this.decider.getStateFract(n2) < 0.01f) {
            e.addSegment(level, 500.0f);
        } else {
            e.addSegment(level, 5.0f);
        }
        e.addSegment(level, 100.0f);
        e.addSegment(0.0f, this.decider.getStateFract(next++) * this.decider.getStateFract(next++) * this.decider.getStateFract(next++) * this.decider.getStateFract(next++) * 20000.0f + 10.0f, new KillTrigger(g));
        g.addInput(sp);
        this.loopLen.setValue(this.decider.getStateFract(next++));
        this.rate.setValue(this.decider.getStateFract(next++) * 2.0f + 0.01f);
        this.pl.addInput(g);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void tick(float tempo, int i) {
        if (i % 2 == 0 && this.eventIndex != -1) {
            this.sound();
            this.eventIndex = -1;
        }
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

