/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_1;

import decider.core.Decider;
import decider.play.DSEControl;
import decider.play.DeciderSoundEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.PolyLimit;
import net.beadsproject.beads.ugens.SamplePlayer;

public class CymbalSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    int time = 0;
    int last = -1;
    PolyLimit pl;
    Glide filtFreq;
    BiquadFilter bf;
    Gain g;

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        AudioContext ac = output.getContext();
        if (this.pl == null) {
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            this.pl = new PolyLimit(ac, 2, 10);
            this.filtFreq = new Glide(ac, 0.0f, 200.0f);
            this.bf = new BiquadFilter(ac, 2);
            this.bf.setFrequency(this.filtFreq);
            this.bf.setQ(0.7f);
            this.bf.addInput(this.pl);
            this.g = new Gain(ac, 2, staticGain);
            this.g.addInput(this.bf);
            output.addInput(this.g);
        }
        this.filtFreq.setValue(DSEControl.getFilterFreq(decider) * 10000.0f + 300.0f);
        if (this.time % 4 == decider.getRng().nextInt(2) && this.last != thisIndex) {
            SamplePlayer s = new SamplePlayer(ac, SampleManager.fromGroup("drm", thisIndex));
            float gainVal = 0.5f * DSEControl.getGain(decider);
            Envelope gainEnv = new Envelope(ac, 0.0f);
            gainEnv.addSegment(gainVal, DSEControl.getDuration(decider) * 400.0f);
            Gain g = new Gain(ac, 2, gainEnv);
            float detune = DSEControl.getParameterA(decider) * 0.1f;
            if (thisIndex % 200 < 50) {
                s.getRateUGen().setValue(0.5f + detune);
            } else if (thisIndex % 200 > 150) {
                s.getRateUGen().setValue(1.0f + detune);
            } else if (thisIndex % 200 > 140) {
                s.getRateUGen().setValue(2.0f + detune);
            }
            g.addInput(s);
            s.setKillListener(g);
            this.pl.addInput(g);
        }
        this.last = thisIndex;
        if (this.time++ == 0) {
            return this.bf;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.g != null) {
            this.g.kill();
        }
    }

    @Override
    public void tick(float tempo, int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        try {
            FileInputStream fis = new FileInputStream(new File("deciders/cymbal_decider2"));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Decider d = (Decider)ois.readObject();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void tick(int i) {
    }

    static {
        SampleManager.group("drm", "audio/Ride", 10);
    }
}

