/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_1;

import decider.core.Decider;
import decider.play.DSEControl;
import decider.play.DeciderSoundEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Pitch;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.Mult;
import net.beadsproject.beads.ugens.OnePoleFilter;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.WavePlayer;

public class StringResSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    private int next;
    private int count = 0;
    private int last = -1;
    private Glide gainVal;
    private Glide filtFreq;
    private Gain gain;
    private WavePlayer ringMod;
    private OnePoleFilter opf;
    private Glide ringModAmount;
    private int[] scale1 = new int[]{0, 3, 5, 7, 10};

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen o, int i, Decider d) {
        AudioContext ac = o.getContext();
        this.next = 0;
        Gain sound = null;
        if (this.gain == null) {
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            this.gainVal = new Glide(ac, 0.0f, 500.0f);
            this.gain = new Gain(ac, 2, new Mult(ac, this.gainVal, (UGen)staticGain));
            this.filtFreq = new Glide(ac, 0.0f, 200.0f);
            this.opf = new OnePoleFilter(ac, this.filtFreq);
            this.opf.addInput(this.gain);
            o.addInput(this.opf);
            sound = this.gain;
            this.ringMod = new WavePlayer(ac, 600.0f, Buffer.SINE);
            this.ringModAmount = new Glide(ac, 0.5f, 200.0f);
        }
        if (this.count % 16 == 0) {
            this.gainVal.setValue(DSEControl.getGain(d) * 0.6f + 0.4f);
            this.filtFreq.setValue(DSEControl.getFilterFreq(d) * 14000.0f + 500.0f);
            this.ringModAmount.setValue((float)Math.pow(DSEControl.getParameterA(d), 1.1f));
        }
        if (this.count % 16 == 0 && this.last != i) {
            Sample s = SampleManager.sample("string");
            if (s == null) {
                System.out.println("problem: string sound not loaded");
            }
            if (s != null) {
                SamplePlayer wp = new SamplePlayer(ac, s);
                wp.setPosition(300.0);
                wp.setLoopType(SamplePlayer.LoopType.LOOP_ALTERNATING);
                wp.getLoopStartUGen().setValue(600.0f);
                wp.getLoopEndUGen().setValue(1000.0f);
                wp.getRateUGen().setValue(this.freq(i, this.scale1) / 440.0f);
                Envelope e = new Envelope(ac, 4.0f);
                Gain g = new Gain(ac, 2, e);
                e.addSegment(4.0f, 1000.0f);
                e.addSegment(0.0f, 3000.0f, 2.0f, new KillTrigger(g));
                Function m = new Function(new UGen[]{wp, this.ringMod, this.ringModAmount}){

                    @Override
                    public float calculate() {
                        float result = this.x[0] * ((this.x[1] * 0.5f - 0.5f) * this.x[2] + 1.0f);
                        return result;
                    }
                };
                g.addInput(m);
                this.gain.addInput(g);
            }
        }
        ++this.count;
        this.last = i;
        return sound;
    }

    private float freq(int index, int[] scale) {
        int note = index % 48 + 24;
        note = Pitch.forceToScale(note, scale);
        return Pitch.mtof(note);
    }

    @Override
    public void destroy() {
        if (this.opf != null) {
            this.opf.kill();
        }
    }

    @Override
    public void tick(float tempo, int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        try {
            FileInputStream fis = new FileInputStream(new File("deciders/string_res_decider"));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Decider d = (Decider)ois.readObject();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void tick(int i) {
    }

    static {
        SampleManager.sample("string", "audio/Viola/viola.aif");
    }
}

