/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_1;

import decider.core.Decider;
import decider.play.DSEControl;
import decider.play.DeciderSoundEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.PolyLimit;
import net.beadsproject.beads.ugens.SamplePlayer;

public class TimpaniSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    int time = 0;
    int last = -1;
    PolyLimit pl;
    Gain g;

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        AudioContext ac = output.getContext();
        if (this.pl == null) {
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            this.pl = new PolyLimit(ac, 2, 10);
            this.g = new Gain(ac, 2, staticGain);
            this.g.addInput(this.pl);
            output.addInput(this.g);
        }
        if (this.time % 4 == 0 && this.last != thisIndex) {
            SamplePlayer s = new SamplePlayer(ac, SampleManager.fromGroup("timp", decider.getRng().nextInt(1000)));
            Gain g = new Gain(ac, 2, 0.5f * DSEControl.getGain(decider));
            if (thisIndex % 20 < 5) {
                s.getRateUGen().setValue(0.5f);
            } else if (thisIndex % 20 > 15) {
                s.getRateUGen().setValue(2.0f);
            } else if (thisIndex % 20 > 13) {
                s.getRateUGen().setValue(3.0f);
            }
            g.addInput(s);
            s.setKillListener(g);
            this.pl.addInput(g);
        }
        this.last = thisIndex;
        if (this.time++ == 0) {
            return this.pl;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this.g != null) {
            this.g.kill();
        }
    }

    @Override
    public void tick(float tempo, int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        try {
            FileInputStream fis = new FileInputStream(new File("deciders/timpani_decider"));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Decider d = (Decider)ois.readObject();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        SampleManager.group("timp", "audio/Timpani");
    }
}

