/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import java.util.Random;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Pitch;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.GranularSamplePlayer;
import net.beadsproject.beads.ugens.Panner;
import net.beadsproject.beads.ugens.PolyLimit;
import net.beadsproject.beads.ugens.SamplePlayer;

public class FilteredPentatonicTuba
implements DeciderSoundEvent {
    public static Slider staticGain;
    int lastIndex;
    int count;
    String fulltb = "fulltb";
    int[] penta = Pitch.pentatonic;
    PolyLimit pl;

    @Override
    public void init() {
        SampleManager.group(this.fulltb, "audio/Full Tuba Normal");
        for (Sample s : SampleManager.getGroup(this.fulltb)) {
            System.out.println(s.getFileName().split("_")[2]);
        }
    }

    Sample getNote(int midi) {
        return SampleManager.fromGroup(this.fulltb, midi + 26);
    }

    Sample getPentaNote(int index) {
        return this.getNote(this.penta[index % 5] + index / 5 * 12);
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        Random rng = decider.getRng();
        Object result = null;
        AudioContext ac = output.getContext();
        if (this.pl == null) {
            this.pl = new PolyLimit(ac, 2, 5);
            this.pl.setSteal(false);
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            Gain main = new Gain(ac, 2, staticGain);
            main.addInput(this.pl);
            output.addInput(main);
        }
        if (thisIndex != this.lastIndex) {
            GranularSamplePlayer sp = new GranularSamplePlayer(ac, this.getPentaNote(thisIndex));
            ((SamplePlayer)sp).getPitchUGen().setValue(rng.nextFloat() < 0.2f ? 3.0f : 4.0f);
            if (sp instanceof GranularSamplePlayer) {
                GranularSamplePlayer gsp = sp;
                gsp.getRateUGen().setValue(rng.nextFloat() * rng.nextFloat() * 7.0f + 0.3f);
                gsp.getGrainIntervalUGen().setValue(rng.nextInt(30) + 20);
                gsp.getGrainSizeUGen().setValue(rng.nextInt(50) + 40);
                gsp.getRandomnessUGen().setValue(rng.nextFloat());
            }
            sp.setKillOnEnd(true);
            Envelope gainEnv = new Envelope(ac, 0.0f);
            Gain g = new Gain(ac, 1, gainEnv);
            g.addInput(sp);
            BiquadFilter bf = new BiquadFilter(ac, 1);
            bf.setFrequency(500.0f);
            bf.addInput(g);
            Panner p = new Panner(ac, rng.nextFloat() * 2.0f - 1.0f);
            p.addInput(bf);
            gainEnv.addSegment(0.8f, rng.nextFloat() * rng.nextFloat() * 4000.0f);
            gainEnv.addSegment(0.0f, (float)rng.nextInt(4000), new KillTrigger(p));
            this.pl.addInput(p);
            result = null;
        }
        ++this.count;
        this.lastIndex = thisIndex;
        return result;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void tick(float tempo, int i) {
    }

    public void tick(int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

