/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.LPRezFilter;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;

public class IrishRallySoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    SamplePlayer sp;
    LPRezFilter lpFilt;
    Envelope gainEnv;
    Gain gain;
    int lastIndex;
    int count;
    TapIn in;
    TapOut out1;
    TapOut out2;

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        float val;
        AudioContext ac = output.getContext();
        if (this.sp == null) {
            this.sp = new SamplePlayer(ac, SampleManager.sample("rally"));
            this.sp.setInterpolationType(SamplePlayer.InterpolationType.CUBIC);
            this.sp.setLoopType(SamplePlayer.LoopType.LOOP_FORWARDS);
            this.sp.setPitch(new Glide(ac, -1.0f, 50.0f));
            this.lpFilt = new LPRezFilter(ac, 2);
            this.lpFilt.addInput(this.sp);
            this.lpFilt.setFrequency(new Glide(ac, 100.0f));
            this.lpFilt.setRes(new Glide(ac, 100.0f));
            this.in = new TapIn(ac, 500.0f);
            this.out1 = new TapOut(ac, this.in, new Glide(ac, 50.0f, 500.0f));
            this.out2 = new TapOut(ac, this.in, new Glide(ac, 50.0f, 500.0f));
            this.in.addInput(this.lpFilt);
            this.gainEnv = new Envelope(ac, 0.0f);
            this.gain = new Gain(ac, 2, this.gainEnv);
            this.gain.addInput(this.lpFilt);
            this.gain.addInput(0, this.out1, 0);
            this.gain.addInput(1, this.out2, 0);
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            Gain main = new Gain(ac, 2, staticGain);
            main.addInput(this.gain);
            output.addInput(main);
        }
        int next = 0;
        if (this.count % (int)((val = decider.getStateFract(next++)) * 1000.0f + 1.0f) == 0) {
            if (thisIndex != this.lastIndex || Math.random() < (double)0.1f) {
                this.sp.setPosition((double)((float)thisIndex % 100.0f / 100.0f) * this.sp.getSample().getLength());
            }
            this.lastIndex = thisIndex;
        }
        ++this.count;
        val = decider.getStateFract(next++);
        this.gainEnv.clear();
        float newGain = (1.0f - val * val) * 0.1f;
        this.gainEnv.addSegment(newGain, 100.0f);
        this.gainEnv.addSegment(newGain, 100.0f);
        this.gainEnv.addSegment(0.0f, 5000.0f);
        val = decider.getStateFract(next++);
        val = decider.getStateFract(next++);
        val = decider.getStateFract(next++);
        if (Math.random() < (double)0.05f) {
            // empty if block
        }
        val = decider.getStateFract(next++);
        val = decider.getStateFract(next++);
        this.lpFilt.getFrequencyUGen().setValue(val * val * 10000.0f + 100.0f);
        val = decider.getStateFract(next++);
        this.lpFilt.getResUGen().setValue(val * 0.9f + 0.05f);
        val = decider.getStateFract(next++);
        this.out1.getDelayUGen().setValue(val * val * 300.0f + 2.0f);
        val = decider.getStateFract(next++);
        this.out2.getDelayUGen().setValue(val * val * 300.0f + 2.0f);
        val = decider.getStateFract(next++);
        this.sp.getPitchUGen().setValue(-1.0f * (float)Math.pow(2.0, (int)(val * 5.0f - 3.0f)));
        return this.sp;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void tick(float tempo, int i) {
    }

    public void tick(int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }

    static {
        SampleManager.sample("rally", System.getProperty("user.home") + "/Music/Audio/Samples/F1/tractor_crash.wav");
    }
}

