/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.PolyLimit;
import net.beadsproject.beads.ugens.SamplePlayer;

public class KorgKitSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    int lastIndex;
    int count;
    PolyLimit pl;
    Glide loopLen;
    Glide rate;

    @Override
    public void init() {
        SampleManager.group("krrg", "/Users/ollie/Music/Audio/Samples/Drum Machines/Korg Rhythm 55");
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        int step;
        UGen result = null;
        AudioContext ac = output.getContext();
        if (this.pl == null) {
            this.pl = new PolyLimit(ac, 2, 10);
            this.pl.setSteal(true);
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            Gain main = new Gain(ac, 2, staticGain);
            main.addInput(this.pl);
            output.addInput(main);
            this.loopLen = new Glide(ac, 0.0f);
            this.rate = new Glide(ac, 1.0f, 50.0f);
        }
        int next = 3;
        if (this.count % (step = (int)(decider.getStateFract(next++) * 100.0f + 20.0f)) == 0 || thisIndex != this.lastIndex) {
            SamplePlayer sp = new SamplePlayer(ac, SampleManager.fromGroup("krrg", thisIndex));
            int n = next++;
            if (decider.getStateFract(n) < 0.5f) {
                sp.setLoopType(SamplePlayer.LoopType.LOOP_ALTERNATING);
            }
            final float len = (float)sp.getSample().getLength();
            Function f = new Function((UGen)this.loopLen){

                @Override
                public float calculate() {
                    return len * 0.6f * (1.0f - this.x[0]) + 0.4f;
                }
            };
            final float baseRate = (float)Math.pow(2.0, (int)(decider.getStateFract(next++) * 3.0f));
            Function f2 = new Function((UGen)this.rate){

                @Override
                public float calculate() {
                    return baseRate * this.x[0];
                }
            };
            sp.setRate(f2);
            sp.setLoopStart(f);
            sp.setInterpolationType(SamplePlayer.InterpolationType.CUBIC);
            sp.setPosition(decider.getRng().nextInt(300));
            Envelope e = new Envelope(ac, 0.0f);
            float level = decider.getStateFract(next++);
            Gain g = new Gain(ac, 2, e);
            int n2 = next++;
            if (decider.getStateFract(n2) < 0.01f) {
                e.addSegment(level, 500.0f);
            } else {
                e.addSegment(level, 5.0f);
            }
            e.addSegment(level, 100.0f);
            e.addSegment(0.0f, decider.getStateFract(next++) * decider.getStateFract(next++) * 5000.0f + 200.0f, new KillTrigger(g));
            g.addInput(sp);
            this.loopLen.setValue(decider.getStateFract(next++));
            int n3 = next++;
            if (decider.getStateFract(n3) < 0.1f) {
                this.rate.setValue(decider.getStateFract(next++) * 2.0f - 0.5f);
            }
            this.pl.addInput(g);
        }
        ++this.count;
        this.lastIndex = thisIndex;
        return result;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void tick(float tempo, int i) {
    }

    public void tick(int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

