/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.GranularSamplePlayer;
import net.beadsproject.beads.ugens.LPRezFilter;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.TapIn;
import net.beadsproject.beads.ugens.TapOut;

public class ReggaeVoxSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    GranularSamplePlayer sp;
    LPRezFilter lpFilt;
    Envelope gainEnv;
    Gain gain;
    int lastIndex;
    int count;
    TapIn in;
    TapOut out1;
    TapOut out2;

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        float val;
        AudioContext ac = output.getContext();
        if (this.sp == null) {
            this.sp = new GranularSamplePlayer(ac, SampleManager.sample("reg"));
            this.sp.setInterpolationType(SamplePlayer.InterpolationType.CUBIC);
            this.sp.setLoopType(SamplePlayer.LoopType.LOOP_FORWARDS);
            this.sp.setPitch(new Glide(ac, -1.0f, 50.0f));
            this.lpFilt = new LPRezFilter(ac, 2);
            this.lpFilt.addInput(this.sp);
            this.lpFilt.setFrequency(new Glide(ac, 100.0f));
            this.lpFilt.setRes(new Glide(ac, 100.0f));
            this.in = new TapIn(ac, 500.0f);
            this.out1 = new TapOut(ac, this.in, new Glide(ac, 50.0f, 500.0f));
            this.out2 = new TapOut(ac, this.in, new Glide(ac, 50.0f, 500.0f));
            this.in.addInput(this.lpFilt);
            this.gainEnv = new Envelope(ac, 0.0f);
            this.gain = new Gain(ac, 2, this.gainEnv);
            this.gain.addInput(this.lpFilt);
            this.gain.addInput(0, this.out1, 0);
            this.gain.addInput(1, this.out2, 0);
            output.addInput(this.gain);
        }
        int next = 0;
        if (this.count % (int)((val = decider.getStateFract(next++)) * 1000.0f + 1.0f) == 0) {
            if (thisIndex != this.lastIndex || Math.random() < (double)0.05f) {
                this.sp.setPosition((double)((float)thisIndex % 100.0f / 100.0f) * this.sp.getSample().getLength());
            }
            this.lastIndex = thisIndex;
        }
        ++this.count;
        val = decider.getStateFract(next++);
        this.gainEnv.clear();
        float newGain = (1.0f - val * val) * 0.05f;
        this.gainEnv.addSegment(newGain, 100.0f);
        this.gainEnv.addSegment(newGain, 100.0f);
        this.gainEnv.addSegment(0.0f, 5000.0f);
        val = decider.getStateFract(next++);
        this.sp.getRateUGen().setValue(val * val * 3.0f + -0.5f);
        val = decider.getStateFract(next++);
        this.sp.getGrainSizeUGen().setValue(val * 100.0f + 50.0f);
        val = decider.getStateFract(next++);
        if (Math.random() < (double)0.05f) {
            this.sp.getGrainIntervalUGen().setValue(val * val * 40.0f + 10.0f);
        }
        val = decider.getStateFract(next++);
        this.sp.getRandomnessUGen().setValue(val * val * 0.099f + 0.01f);
        val = decider.getStateFract(next++);
        this.sp.getRandomPanUGen().setValue(val * val * 0.1f + 0.01f);
        val = decider.getStateFract(next++);
        this.lpFilt.getFrequencyUGen().setValue(val * val * 20000.0f + 100.0f);
        val = decider.getStateFract(next++);
        this.lpFilt.getResUGen().setValue(val * 0.95f + 0.05f);
        val = decider.getStateFract(next++);
        this.out1.getDelayUGen().setValue(val * val * 300.0f + 2.0f);
        val = decider.getStateFract(next++);
        this.out2.getDelayUGen().setValue(val * val * 300.0f + 2.0f);
        val = decider.getStateFract(next++);
        return this.sp;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void tick(float tempo, int i) {
    }

    public void tick(int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }

    static {
        SampleManager.sample("reg", System.getProperty("user.home") + "/Music/Audio/Samples/Reggae downloads/Reggae Sample Pack-Acapellas Classic Voices Horns Drums Stabs Etc/reggae sample pack-acapellas.classic voices.horns.drums.stabs.etc/reggaeAcapella.mp3");
    }
}

