/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import java.util.Random;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.Pitch;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.BiquadFilter;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.Panner;
import net.beadsproject.beads.ugens.PolyLimit;
import net.beadsproject.beads.ugens.SamplePlayer;
import net.beadsproject.beads.ugens.WavePlayer;

public class StaccatoPentatonicTuba
implements DeciderSoundEvent {
    public static Slider staticGain;
    int lastIndex;
    int count;
    String fulltb = "fulltb";
    int[] penta = Pitch.pentatonic;
    int counter = 0;
    Glide lfo1Freq;
    Glide lfo2Freq;
    Glide lfo3Freq;
    WavePlayer lfo1;
    WavePlayer lfo2;
    WavePlayer lfo3;
    PolyLimit pl;

    @Override
    public void init() {
        SampleManager.group(this.fulltb, "audio/Full Tuba Normal");
        for (Sample s : SampleManager.getGroup(this.fulltb)) {
            System.out.println(s.getFileName().split("_")[2]);
        }
    }

    Sample getNote(int midi) {
        return SampleManager.fromGroup(this.fulltb, midi + 26);
    }

    Sample getPentaNote(int index) {
        return this.getNote(this.penta[index % 5] + 36);
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        Random rng = decider.getRng();
        Panner result = null;
        AudioContext ac = output.getContext();
        if (this.pl == null) {
            this.pl = new PolyLimit(ac, 2, 5);
            this.pl.setSteal(false);
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            Gain main = new Gain(ac, 2, staticGain);
            main.addInput(this.pl);
            output.addInput(main);
            this.lfo1Freq = new Glide(ac, 0.1f);
            this.lfo2Freq = new Glide(ac, 0.1f);
            this.lfo3Freq = new Glide(ac, 0.1f);
            this.lfo1 = new WavePlayer(ac, this.lfo1Freq, Buffer.SINE);
            this.lfo2 = new WavePlayer(ac, this.lfo2Freq, Buffer.SINE);
            this.lfo3 = new WavePlayer(ac, this.lfo3Freq, Buffer.SINE);
        }
        int next = 0;
        float prob = 0.1f;
        float x = decider.getStateFract(next++);
        int n = next++;
        if (decider.getStateFract(n) < 0.1f) {
            prob = x;
        }
        this.lfo1Freq.setValue(decider.getStateFract(next++) * 4.0f);
        this.lfo2Freq.setValue(decider.getStateFract(next++) * 4.0f);
        this.lfo3Freq.setValue(decider.getStateFract(next++) * 4.0f);
        if (thisIndex != this.lastIndex && prob < 0.3f) {
            System.out.println(thisIndex);
            int step = (int)(decider.getStateFract(next++) * 5.0f);
            this.counter += step;
            Sample s = this.getPentaNote(this.counter);
            SamplePlayer sp = new SamplePlayer(ac, s);
            sp.setPosition(s.getLength() * 0.1);
            sp.getPitchUGen().setValue(decider.getStateFract(next++) < 0.1f ? 1.0f : 2.0f);
            Envelope gainEnv = new Envelope(ac, 0.0f);
            gainEnv.addSegment(0.6f * decider.getStateFract(next++) + 0.2f, 10.0f);
            Function gainFunc = new Function(new UGen[]{gainEnv, this.lfo1}){

                @Override
                public float calculate() {
                    return this.x[0] * (0.5f + 0.5f * (this.x[1] + 1.0f) / 2.0f);
                }
            };
            Gain g = new Gain(ac, 2, gainFunc);
            g.addInput(sp);
            BiquadFilter bf = new BiquadFilter(ac, 2);
            bf.setQ(0.1f);
            bf.setFrequency(2000.0f * decider.getStateFract(next++) + 500.0f);
            bf.addInput(g);
            gainEnv.addSegment(0.0f, 5000.0f * decider.getStateFract(next++) + 100.0f, 1.3f);
            Panner p = new Panner(ac, decider.getStateFract(next++) * 0.4f - 0.2f);
            p.addInput(bf);
            gainEnv.addSegment(0.0f, 100.0f, new KillTrigger(p));
            this.pl.addInput(p);
            result = p;
        }
        ++this.count;
        this.lastIndex = thisIndex;
        return result;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void tick(float tempo, int i) {
    }

    public void tick(int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }
}

