/*
 * Decompiled with CFR 0.152.
 */
package my_sound_events_2;

import decider.core.Decider;
import decider.play.DeciderSoundEvent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.ugens.Compressor;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Glide;
import net.beadsproject.beads.ugens.GranularSamplePlayer;
import net.beadsproject.beads.ugens.LPRezFilter;
import net.beadsproject.beads.ugens.SamplePlayer;

public class WoodScratchSoundEvent
implements DeciderSoundEvent {
    public static Slider staticGain;
    GranularSamplePlayer sp;
    LPRezFilter lpFilt;
    Compressor comp;
    Envelope gainEnv;
    Gain gain;

    @Override
    public void init() {
    }

    @Override
    public UGen play(UGen output, int thisIndex, Decider decider) {
        AudioContext ac = output.getContext();
        if (this.sp == null) {
            this.sp = new GranularSamplePlayer(ac, SampleManager.sample("wood"));
            this.sp.setLoopType(SamplePlayer.LoopType.LOOP_FORWARDS);
            this.sp.setPitch(new Glide(ac, 0.25f, 10.0f));
            this.sp.setRate(new Glide(ac, 1.0f, 500.0f));
            this.sp.setGrainInterval(new Glide(ac, 500.0f));
            this.sp.getRandomPanUGen().setValue(0.8f);
            this.lpFilt = new LPRezFilter(ac, 2);
            this.lpFilt.addInput(this.sp);
            this.lpFilt.setFrequency(new Glide(ac, 100.0f));
            this.lpFilt.setRes(new Glide(ac, 100.0f));
            this.comp = new Compressor(ac, 2);
            this.comp.setRatio(50.0f);
            this.comp.setThreshold(0.5f);
            this.comp.addInput(this.lpFilt);
            this.gainEnv = new Envelope(ac, 0.0f);
            this.gain = new Gain(ac, 2, this.gainEnv);
            this.gain.addInput(this.lpFilt);
            if (staticGain == null) {
                staticGain = new Slider(ac, "", 0.0f, 2.0f, 1.0f);
            }
            Gain main = new Gain(ac, 2, staticGain);
            main.addInput(this.gain);
            output.addInput(main);
        }
        int next = 0;
        float val = decider.getStateFract(next++);
        this.gainEnv.clear();
        float newGain = (1.0f - val * val) * 0.5f;
        this.gainEnv.addSegment(newGain, 100.0f);
        this.gainEnv.addSegment(newGain, 1000.0f);
        this.gainEnv.addSegment(0.0f, 5000.0f);
        val = decider.getStateFract(next++);
        this.sp.getRateUGen().setValue(val * val * 0.5f + 0.1f);
        val = decider.getStateFract(next++);
        this.sp.getGrainSizeUGen().setValue(val * 100.0f + 50.0f);
        val = decider.getStateFract(next++);
        if (Math.random() < (double)0.05f) {
            this.sp.getGrainIntervalUGen().setValue(val * 40.0f + 10.0f);
        }
        val = decider.getStateFract(next++);
        this.sp.getRandomnessUGen().setValue(val * val * 0.99f + 0.01f);
        val = decider.getStateFract(next++);
        this.lpFilt.getFrequencyUGen().setValue(val * val * 5000.0f + 500.0f);
        val = decider.getStateFract(next++);
        this.lpFilt.getResUGen().setValue(val * 0.8f + 0.2f);
        if (Math.random() < (double)0.01f) {
            this.sp.getPitchUGen().setValue((float)Math.pow(2.0, (int)(Math.random() * 5.0 - 4.0)));
        }
        return this.sp;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void tick(float tempo, int i) {
    }

    @Override
    public Decider getPreferredDecider() {
        return null;
    }

    static {
        SampleManager.sample("wood", System.getProperty("user.home") + "/Music/Audio/Loops/best live breaks 2/woodloop175-4.aiff");
    }
}

