/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.util.Hashtable;
import java.util.List;
import net.beadsproject.beads.analysis.AudioSegmenter;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.FeatureFrame;
import net.beadsproject.beads.analysis.FeatureSet;
import net.beadsproject.beads.analysis.FeatureTrack;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.analysis.SegmentMaker;
import net.beadsproject.beads.analysis.featureextractors.FFT;
import net.beadsproject.beads.analysis.featureextractors.Frequency;
import net.beadsproject.beads.analysis.featureextractors.MFCC;
import net.beadsproject.beads.analysis.featureextractors.MelSpectrum;
import net.beadsproject.beads.analysis.featureextractors.PeakDetector;
import net.beadsproject.beads.analysis.featureextractors.Power;
import net.beadsproject.beads.analysis.featureextractors.PowerSpectrum;
import net.beadsproject.beads.analysis.featureextractors.SpectralCentroid;
import net.beadsproject.beads.analysis.featureextractors.SpectralDifference;
import net.beadsproject.beads.analysis.featureextractors.SpectralPeaks;
import net.beadsproject.beads.analysis.segmenters.ShortFrameSegmenter;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class Analyzer
implements SegmentMaker {
    private static AnalysisSettings defaultSettings = new AnalysisSettings();
    private ShortFrameSegmenter sfs;
    private FeatureSet results;
    private Hashtable<Class<?>, Object> extractorArrangement;
    private SegmentMaker beatSegmentMaker;

    public Analyzer(AudioContext ac, List<Class<? extends FeatureExtractor<?, ?>>> extractors) {
        this(ac, extractors, defaultSettings);
    }

    public Analyzer(AudioContext ac, List<Class<? extends FeatureExtractor<?, ?>>> extractors, AnalysisSettings settings) {
        this.setup(ac, extractors, settings);
    }

    @Override
    public void addSegmentListener(SegmentListener sl) {
        this.sfs.addSegmentListener(sl);
    }

    @Override
    public void removeSegmentListener(SegmentListener sl) {
        this.sfs.removeSegmentListener(sl);
    }

    public void addBeatListener(SegmentListener sl) {
        this.beatSegmentMaker.addSegmentListener(sl);
    }

    public void removeBeatListener(SegmentListener sl) {
        this.beatSegmentMaker.removeSegmentListener(sl);
    }

    public void listenTo(UGen ugen) {
        this.sfs.addInput(0, ugen, 0);
    }

    public void updateFrom(UGen ugen) {
        ugen.addDependent(this.sfs);
    }

    public FeatureFrame getLastLowLevelFrame() {
        return this.results.get("Low Level").getLastFrame();
    }

    public FeatureFrame getLastBeatFrame() {
        return this.results.get("Beats").getLastFrame();
    }

    public Object getElement(Class<?> classID) {
        return this.extractorArrangement.get(classID);
    }

    public FeatureSet getResults() {
        return this.results;
    }

    private void setup(AudioContext ac, List<Class<? extends FeatureExtractor<?, ?>>> extractors, AnalysisSettings settings) {
        this.results = new FeatureSet();
        FeatureTrack lowLevel = new FeatureTrack();
        FeatureTrack beats = new FeatureTrack();
        this.results.add("Low Level", lowLevel);
        this.results.add("Beats", beats);
        this.extractorArrangement = new Hashtable();
        this.extractorArrangement.put(AudioContext.class, ac);
        this.sfs = new ShortFrameSegmenter(ac);
        this.sfs.setChunkSize(settings.chunkSize);
        this.sfs.setHopSize(settings.hopSize);
        this.sfs.addSegmentListener(lowLevel);
        this.extractorArrangement.put(AudioSegmenter.class, this.sfs);
        if (extractors != null) {
            for (Class<FeatureExtractor<?, ?>> clazz : extractors) {
                if (clazz.equals(PowerSpectrum.class)) {
                    Analyzer.powerSpectrum(this.extractorArrangement);
                    continue;
                }
                if (clazz.equals(FFT.class)) {
                    Analyzer.fft(this.extractorArrangement);
                    continue;
                }
                if (clazz.equals(Frequency.class)) {
                    Analyzer.frequency(this.extractorArrangement);
                    continue;
                }
                if (clazz.equals(MelSpectrum.class)) {
                    Analyzer.melSpectrum(this.extractorArrangement);
                    continue;
                }
                if (clazz.equals(MFCC.class)) {
                    Analyzer.mfcc(this.extractorArrangement);
                    continue;
                }
                if (clazz.equals(SpectralPeaks.class)) {
                    Analyzer.spectralPeaks(this.extractorArrangement);
                    continue;
                }
                if (clazz.equals(Power.class)) {
                    Analyzer.power(this.extractorArrangement);
                    continue;
                }
                if (clazz.equals(SpectralCentroid.class)) {
                    Analyzer.spectralCentroid(this.extractorArrangement);
                    continue;
                }
                System.err.println("Analyzer: unknown extractor class: " + clazz);
            }
        }
        Analyzer.spectralDifference(this.extractorArrangement);
        for (Class<FeatureExtractor<Object, Object>> clazz : this.extractorArrangement.keySet()) {
            if (!(this.extractorArrangement.get(clazz) instanceof FeatureExtractor)) continue;
            lowLevel.addFeatureExtractor((FeatureExtractor)this.extractorArrangement.get(clazz));
        }
        PeakDetector d = new PeakDetector();
        this.beatSegmentMaker = d;
        d.setThreshold(0.1f);
        d.setAlpha(0.9f);
        d.setResetDelay(200.0f);
        SpectralDifference spectralDifference = (SpectralDifference)this.extractorArrangement.get(SpectralDifference.class);
        spectralDifference.addListener(d);
        spectralDifference.setDifferenceType(SpectralDifference.DifferenceType.POSITIVEMEANDIFFERENCE);
        d.addSegmentListener(beats);
    }

    public void setFrameMemory(int fm) {
        for (FeatureTrack ft : this.results.tracks().values()) {
            ft.setFrameMemory(fm);
        }
    }

    private static void spectralPeaks(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(SpectralPeaks.class)) {
            Analyzer.powerSpectrum(extractorArrangement);
            AudioContext ac = (AudioContext)extractorArrangement.get(AudioContext.class);
            SpectralPeaks sp = new SpectralPeaks(ac, 10);
            PowerSpectrum ps = (PowerSpectrum)extractorArrangement.get(PowerSpectrum.class);
            ps.addListener(sp);
            extractorArrangement.put(SpectralPeaks.class, sp);
        }
    }

    private static void spectralDifference(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(SpectralDifference.class)) {
            Analyzer.powerSpectrum(extractorArrangement);
            AudioContext ac = (AudioContext)extractorArrangement.get(AudioContext.class);
            SpectralDifference sd = new SpectralDifference(ac.getSampleRate());
            sd.setDifferenceType(SpectralDifference.DifferenceType.POSITIVERMS);
            PowerSpectrum ps = (PowerSpectrum)extractorArrangement.get(PowerSpectrum.class);
            ps.addListener(sd);
            extractorArrangement.put(SpectralDifference.class, sd);
        }
    }

    private static void mfcc(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(MFCC.class)) {
            Analyzer.melSpectrum(extractorArrangement);
            MFCC mfcc = new MFCC(20);
            MelSpectrum ms = (MelSpectrum)extractorArrangement.get(MelSpectrum.class);
            ms.addListener(mfcc);
            extractorArrangement.put(MFCC.class, mfcc);
        }
    }

    private static void melSpectrum(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(MelSpectrum.class)) {
            Analyzer.powerSpectrum(extractorArrangement);
            AudioContext ac = (AudioContext)extractorArrangement.get(AudioContext.class);
            MelSpectrum ms = new MelSpectrum(ac.getSampleRate(), 200);
            PowerSpectrum ps = (PowerSpectrum)extractorArrangement.get(PowerSpectrum.class);
            ps.addListener(ms);
            extractorArrangement.put(MelSpectrum.class, ms);
        }
    }

    private static void frequency(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(Frequency.class)) {
            Analyzer.powerSpectrum(extractorArrangement);
            AudioContext ac = (AudioContext)extractorArrangement.get(AudioContext.class);
            Frequency f = new Frequency(ac.getSampleRate());
            PowerSpectrum ps = (PowerSpectrum)extractorArrangement.get(PowerSpectrum.class);
            ps.addListener(f);
            extractorArrangement.put(Frequency.class, f);
        }
    }

    private static void spectralCentroid(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(SpectralCentroid.class)) {
            Analyzer.powerSpectrum(extractorArrangement);
            AudioContext ac = (AudioContext)extractorArrangement.get(AudioContext.class);
            SpectralCentroid sc = new SpectralCentroid(ac.getSampleRate());
            PowerSpectrum ps = (PowerSpectrum)extractorArrangement.get(PowerSpectrum.class);
            ps.addListener(sc);
            extractorArrangement.put(SpectralCentroid.class, sc);
        }
    }

    private static void powerSpectrum(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(PowerSpectrum.class)) {
            Analyzer.fft(extractorArrangement);
            PowerSpectrum ps = new PowerSpectrum();
            FFT fft = (FFT)extractorArrangement.get(FFT.class);
            fft.addListener(ps);
            extractorArrangement.put(PowerSpectrum.class, ps);
        }
    }

    private static void fft(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(FFT.class)) {
            FFT fft = new FFT();
            AudioSegmenter as = (AudioSegmenter)extractorArrangement.get(AudioSegmenter.class);
            as.addListener(fft);
            extractorArrangement.put(FFT.class, fft);
        }
    }

    private static void power(Hashtable<Class<?>, Object> extractorArrangement) {
        if (!extractorArrangement.containsKey(Power.class)) {
            Power p = new Power();
            AudioSegmenter as = (AudioSegmenter)extractorArrangement.get(AudioSegmenter.class);
            as.addListener(p);
            extractorArrangement.put(Power.class, p);
        }
    }

    static {
        Analyzer.defaultSettings.hopSize = 512;
        Analyzer.defaultSettings.chunkSize = 1024;
    }

    public static class AnalysisSettings {
        int hopSize;
        int chunkSize;

        public AnalysisSettings(int hopSize, int chunkSize) {
            this.hopSize = hopSize;
            this.chunkSize = chunkSize;
        }

        public AnalysisSettings() {
        }
    }
}

