/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class FeatureFrame
implements Serializable,
Comparable<FeatureFrame> {
    private static final long serialVersionUID = 1L;
    private double startTimeMS;
    private double endTimeMS;
    private Hashtable<String, Object> features;

    public FeatureFrame(double startTimeMS, double endTimeMS) {
        this.startTimeMS = startTimeMS;
        this.endTimeMS = endTimeMS;
        this.features = new Hashtable();
    }

    public double getStartTimeMS() {
        return this.startTimeMS;
    }

    public void setStartTimeMS(double startTimeMS) {
        this.startTimeMS = startTimeMS;
    }

    public double getEndTimeMS() {
        return this.endTimeMS;
    }

    public void setEndTimeMS(double endTimeMS) {
        this.endTimeMS = endTimeMS;
    }

    public void add(String s, Object f) {
        this.features.put(s, f);
    }

    public Object get(String s) {
        return this.features.get(s);
    }

    public Enumeration<String> keys() {
        return this.features.keys();
    }

    public boolean containsTime(double timeMS) {
        return timeMS >= this.startTimeMS && timeMS <= this.endTimeMS;
    }

    public String toString() {
        String result = "";
        result = result + "Start Time: " + this.startTimeMS + " (ms)";
        result = result + "\nEnd Time  : " + this.endTimeMS + " (ms)";
        for (String s : this.features.keySet()) {
            int i;
            Object fdata;
            result = result + "\n" + s + ": ";
            Object data = this.features.get(s);
            if (data instanceof float[]) {
                fdata = (float[])data;
                for (i = 0; i < ((float[])fdata).length; ++i) {
                    result = result + fdata[i] + " ";
                }
                continue;
            }
            if (data instanceof float[][]) {
                fdata = (float[][])data;
                for (i = 0; i < ((float[])fdata).length; ++i) {
                    for (int j = 0; j < ((float)fdata[i]).length; ++j) {
                        result = result + (float)fdata[i][j] + " ";
                    }
                    result = result + ", ";
                }
                continue;
            }
            result = result + data;
        }
        return result;
    }

    @Override
    public int compareTo(FeatureFrame other) {
        if (this.startTimeMS < other.startTimeMS) {
            return -1;
        }
        if (this.startTimeMS > other.startTimeMS) {
            return 1;
        }
        return 0;
    }

    public int numFeatures() {
        return this.features.size();
    }
}

