/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Map;
import net.beadsproject.beads.analysis.FeatureTrack;
import net.beadsproject.beads.data.Sample;

public class FeatureSet {
    private Hashtable<String, FeatureTrack> tracks = new Hashtable();
    private Hashtable<String, Object> globalFeatures = new Hashtable();
    private File file;

    public static FeatureSet forSample(Sample s) {
        File featureFile;
        String sampleFilePath = s.getFileName();
        FeatureSet fs = null;
        if (sampleFilePath != null && (featureFile = new File(sampleFilePath + ".features")).exists()) {
            fs = new FeatureSet(featureFile);
        }
        return fs;
    }

    public FeatureSet() {
    }

    public FeatureSet(File file) {
        this();
        this.read(file);
    }

    public FeatureTrack get(String trackName) {
        return this.tracks.get(trackName);
    }

    public void add(String trackName, FeatureTrack track) {
        this.tracks.put(trackName, track);
    }

    public boolean contains(String trackName) {
        return this.tracks.containsKey(trackName);
    }

    public void addGlobal(String s, Object f) {
        this.globalFeatures.put(s, f);
    }

    public Object getGlobal(String s) {
        return this.globalFeatures.get(s);
    }

    public boolean containsGlobal(String s) {
        return this.globalFeatures.containsKey(s);
    }

    public void write() {
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.tracks);
            oos.writeObject(this.globalFeatures);
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void read(File file) {
        this.file = file;
        this.read();
    }

    private void read() {
        if (this.file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(this.file);
                ObjectInputStream ois = new ObjectInputStream(fis);
                this.tracks = (Hashtable)ois.readObject();
                this.globalFeatures = (Hashtable)ois.readObject();
                ois.close();
                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void refresh() {
        this.read();
    }

    public void write(File file) {
        this.file = file;
        this.write();
    }

    public void write(String fn) {
        this.write(new File(fn));
    }

    public Map<String, FeatureTrack> tracks() {
        return this.tracks;
    }

    public void printGlobalFeatures() {
        System.out.println("Features for " + this + ":");
        for (String s : this.globalFeatures.keySet()) {
            System.out.println("- " + s);
        }
    }
}

