/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.FeatureFrame;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.core.TimeStamp;

public class FeatureTrack
implements Serializable,
Iterable<FeatureFrame>,
SegmentListener {
    private static final long serialVersionUID = 1L;
    private SortedSet<FeatureFrame> frames = new TreeSet<FeatureFrame>();
    private Map<Integer, SortedSet<FeatureFrame>> framesInBlocks = new Hashtable<Integer, SortedSet<FeatureFrame>>();
    private int skipMS = 1000;
    private transient List<FeatureExtractor<?, ?>> extractors = new ArrayList();
    private int frameMemory = -1;

    public void add(FeatureFrame ff) {
        if (this.frameMemory != 0) {
            this.frames.add(ff);
            int startIndex = (int)(ff.getStartTimeMS() / (double)this.skipMS);
            int endIndex = (int)(ff.getEndTimeMS() / (double)this.skipMS);
            for (int i = startIndex; i <= endIndex; ++i) {
                SortedSet<Object> frameSet;
                if (this.framesInBlocks.containsKey(i)) {
                    frameSet = this.framesInBlocks.get(i);
                } else {
                    frameSet = new TreeSet();
                    this.framesInBlocks.put(i, frameSet);
                }
                frameSet.add(ff);
            }
            this.frameMemoryCheck();
        }
    }

    public void remove(FeatureFrame ff) {
        this.frames.remove(ff);
        int startIndex = (int)(ff.getStartTimeMS() / (double)this.skipMS);
        int endIndex = (int)(ff.getEndTimeMS() / (double)this.skipMS);
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!this.framesInBlocks.containsKey(i)) continue;
            SortedSet<FeatureFrame> frameSet = this.framesInBlocks.get(i);
            frameSet.remove(ff);
        }
    }

    public void removeRange(double startRangeMS, double endRangeMS) {
        FeatureFrame ff2;
        ArrayList<FeatureFrame> toRemove = new ArrayList<FeatureFrame>();
        FeatureFrame startFrame = this.getFrameAt(startRangeMS);
        if (startFrame == null) {
            return;
        }
        toRemove.add(startFrame);
        Iterator iterator = this.frames.tailSet(startFrame).iterator();
        while (iterator.hasNext() && (ff2 = (FeatureFrame)iterator.next()).getStartTimeMS() < endRangeMS) {
            toRemove.add(ff2);
        }
        for (FeatureFrame ff2 : toRemove) {
            this.remove(ff2);
        }
    }

    public FeatureFrame get(int index) {
        if (index >= this.frames.size()) {
            return null;
        }
        int count = 0;
        FeatureFrame result = null;
        Iterator iterator = this.frames.iterator();
        while (iterator.hasNext()) {
            FeatureFrame ff;
            result = ff = (FeatureFrame)iterator.next();
            if (count == index) break;
            ++count;
        }
        return result;
    }

    public FeatureFrame getFrameAt(double timeMS) {
        int startTimeIndex = (int)(timeMS / (double)this.skipMS);
        SortedSet<FeatureFrame> localSet = this.framesInBlocks.get(startTimeIndex);
        if (localSet != null) {
            for (FeatureFrame ff : localSet) {
                if (!ff.containsTime(timeMS)) continue;
                return ff;
            }
        }
        return null;
    }

    public FeatureFrame getFrameBefore(double timeMS) {
        FeatureFrame ff = this.getFrameAt(timeMS);
        if (ff == null) {
            ff = this.frames.last();
        }
        return ff;
    }

    public FeatureFrame getLastFrame() {
        if (this.frames.size() > 0) {
            return this.frames.last();
        }
        return null;
    }

    public void addFeatureExtractor(FeatureExtractor<?, ?> e) {
        this.extractors.add(e);
    }

    public void removeFeatureExtractor(FeatureExtractor<?, ?> e) {
        this.extractors.remove(e);
    }

    @Override
    public void newSegment(TimeStamp startTime, TimeStamp endTime) {
        FeatureFrame ff = new FeatureFrame(startTime.getTimeMS(), endTime.getTimeMS());
        for (FeatureExtractor<?, ?> e : this.extractors) {
            Object features = e.getFeatures();
            try {
                Method cloneMethod = features.getClass().getMethod("clone", new Class[0]);
                ff.add(e.getName(), cloneMethod.invoke(features, new Object[0]));
            }
            catch (Exception e1) {
                if (features instanceof float[]) {
                    ff.add(e.getName(), ((float[])features).clone());
                    continue;
                }
                if (features instanceof int[]) {
                    ff.add(e.getName(), ((int[])features).clone());
                    continue;
                }
                if (features instanceof double[]) {
                    ff.add(e.getName(), ((double[])features).clone());
                    continue;
                }
                if (features instanceof byte[]) {
                    ff.add(e.getName(), ((byte[])features).clone());
                    continue;
                }
                if (features instanceof short[]) {
                    ff.add(e.getName(), ((short[])features).clone());
                    continue;
                }
                if (features instanceof long[]) {
                    ff.add(e.getName(), ((long[])features).clone());
                    continue;
                }
                if (features instanceof Object[]) {
                    ff.add(e.getName(), ((Object[])features).clone());
                    continue;
                }
                if (features instanceof boolean[]) {
                    ff.add(e.getName(), ((boolean[])features).clone());
                    continue;
                }
                ff.add(e.getName(), features);
            }
        }
        this.add(ff);
    }

    @Override
    public Iterator<FeatureFrame> iterator() {
        return this.frames.iterator();
    }

    public int getFrameMemory() {
        return this.frameMemory;
    }

    public void setFrameMemory(int frameMemory) {
        this.frameMemory = frameMemory;
        this.frameMemoryCheck();
    }

    private void frameMemoryCheck() {
        if (this.frameMemory > 0) {
            while (this.frames.size() > this.frameMemory) {
                FeatureFrame ff = this.frames.first();
                this.remove(ff);
            }
        }
    }

    public int getNumberOfFrames() {
        return this.frames.size();
    }

    public void clear() {
        this.frames.clear();
        this.framesInBlocks.clear();
    }
}

