/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.core.TimeStamp;

public class FFT
extends FeatureExtractor<float[][], float[]> {
    protected float[] fftReal;
    protected float[] fftImag;
    private float[] dataCopy = null;

    public FFT() {
        this.features = new float[2][];
    }

    @Override
    public void process(TimeStamp startTime, TimeStamp endTime, float[] data) {
        if (this.dataCopy == null || this.dataCopy.length != data.length) {
            this.dataCopy = new float[data.length];
        }
        System.arraycopy(data, 0, this.dataCopy, 0, data.length);
        FFT.fft(this.dataCopy, this.dataCopy.length, true);
        this.numFeatures = this.dataCopy.length;
        this.fftReal = FFT.calculateReal(this.dataCopy, this.dataCopy.length);
        this.fftImag = FFT.calculateImaginary(this.dataCopy, this.dataCopy.length);
        ((float[][])this.features)[0] = this.fftReal;
        ((float[][])this.features)[1] = this.fftImag;
        this.forward(startTime, endTime);
    }

    public static float binFrequency(float samplingFrequency, int blockSize, float binNumber) {
        return binNumber * samplingFrequency / (float)blockSize;
    }

    public static float binNumber(float samplingFrequency, int blockSize, float freq) {
        return (float)blockSize * freq / samplingFrequency;
    }

    public static float nyquist(float samplingFrequency) {
        return samplingFrequency / 2.0f;
    }

    protected static float[] calculateReal(float[] spectrum, int length) {
        float[] real = new float[length];
        real[0] = spectrum[0];
        real[real.length / 2] = spectrum[1];
        int i = 1;
        for (int j = real.length - 1; i < j; ++i, --j) {
            real[j] = real[i] = spectrum[2 * i];
        }
        return real;
    }

    protected static float[] calculateImaginary(float[] spectrum, int length) {
        float[] imag = new float[length];
        int i = 1;
        for (int j = imag.length - 1; i < j; ++i, --j) {
            imag[j] = spectrum[2 * i + 1];
            imag[i] = -imag[j];
        }
        return imag;
    }

    protected static void fft(float[] data, int n, boolean isign) {
        float c2;
        float c1 = 0.5f;
        double theta = Math.PI / (double)(n >> 1);
        if (isign) {
            c2 = -0.5f;
            FFT.four1(data, n >> 1, true);
        } else {
            c2 = 0.5f;
            theta = -theta;
        }
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        int np3 = n + 3;
        int imax = n >> 2;
        for (int i = 2; i <= imax; ++i) {
            int i1 = i + i - 1;
            int i2 = 1 + i1;
            int i3 = np3 - i2;
            int i4 = 1 + i3;
            float h1i = c1 * (data[--i2] - data[--i4]);
            float h2r = -c2 * (data[i2] + data[i4]);
            float h1r = c1 * (data[--i1] + data[--i3]);
            float h2i = c2 * (data[i1] - data[i3]);
            data[i1] = (float)((double)h1r + wr * (double)h2r - wi * (double)h2i);
            data[i2] = (float)((double)h1i + wr * (double)h2i + wi * (double)h2r);
            data[i3] = (float)((double)h1r - wr * (double)h2r + wi * (double)h2i);
            data[i4] = (float)((double)(-h1i) + wr * (double)h2i + wi * (double)h2r);
            wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
        }
        if (isign) {
            float tmp = data[0];
            data[0] = data[0] + data[1];
            data[1] = tmp - data[1];
        } else {
            float tmp = data[0];
            data[0] = c1 * (tmp + data[1]);
            data[1] = c1 * (tmp - data[1]);
            FFT.four1(data, n >> 1, false);
        }
    }

    private static void four1(float[] data, int nn, boolean isign) {
        int n = nn << 1;
        int j = 1;
        for (int i = 1; i < n; i += 2) {
            int m;
            if (j > i) {
                float swap = data[j - 1];
                data[j - 1] = data[i - 1];
                data[i - 1] = swap;
                swap = data[j];
                data[j] = data[i];
                data[i] = swap;
            }
            for (m = n >> 1; m >= 2 && j > m; j -= m, m >>= 1) {
            }
            j += m;
        }
        int mmax = 2;
        while (n > mmax) {
            int istep = mmax << 1;
            double theta = 6.28318530717959 / (double)mmax;
            if (!isign) {
                theta = -theta;
            }
            double wtemp = Math.sin(0.5 * theta);
            double wpr = -2.0 * wtemp * wtemp;
            double wpi = Math.sin(theta);
            double wr = 1.0;
            double wi = 0.0;
            for (int m = 1; m < mmax; m += 2) {
                for (int i = m; i <= n; i += istep) {
                    int j2 = i + mmax;
                    float tempr = (float)(wr * (double)data[j2 - 1] - wi * (double)data[j2]);
                    float tempi = (float)(wr * (double)data[j2] + wi * (double)data[j2 - 1]);
                    data[j2 - 1] = data[i - 1] - tempr;
                    data[j2] = data[i] - tempi;
                    int n2 = i - 1;
                    data[n2] = data[n2] + tempr;
                    int n3 = i;
                    data[n3] = data[n3] + tempi;
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
            }
            mmax = istep;
        }
    }
}

