/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.core.TimeStamp;

public class Frequency
extends FeatureExtractor<Float, float[]> {
    static final int FIRSTBAND = 3;
    private float bin2hz;
    private int bufferSize = -1;
    private float sampleRate;

    public Frequency(float sampleRate) {
        this.sampleRate = sampleRate;
        this.features = null;
    }

    @Override
    public synchronized void process(TimeStamp startTime, TimeStamp endTime, float[] powerSpectrum) {
        if (this.bufferSize != powerSpectrum.length) {
            this.bufferSize = powerSpectrum.length;
            this.bin2hz = this.sampleRate / (float)(2 * this.bufferSize);
        }
        this.features = null;
        double pmax = -1.0;
        int maxbin = 0;
        for (int band = 3; band < powerSpectrum.length; ++band) {
            double pwr = powerSpectrum[band];
            if (!(pwr > pmax)) continue;
            pmax = pwr;
            maxbin = band;
        }
        double yz = powerSpectrum[maxbin];
        double ym = maxbin <= 0 ? (double)powerSpectrum[maxbin] : (double)powerSpectrum[maxbin - 1];
        double yp = maxbin < powerSpectrum.length - 1 ? (double)powerSpectrum[maxbin + 1] : (double)powerSpectrum[maxbin];
        double k = (yp + ym) / 2.0 - yz;
        double x0 = (ym - yp) / (4.0 * k);
        this.features = Float.valueOf((float)((double)this.bin2hz * ((double)maxbin + x0)));
        this.forward(startTime, endTime);
    }

    @Override
    public String[] getFeatureDescriptions() {
        return new String[]{"frequency"};
    }
}

