/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import java.util.Arrays;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.core.TimeStamp;

public class MFCC
extends FeatureExtractor<float[], float[]> {
    private double[][] DCTcoeffs;
    private int inputLength;

    public MFCC(int numCoeffs) {
        this.setNumberOfFeatures(numCoeffs);
        this.features = new float[this.numFeatures];
        this.featureDescriptions = new String[this.numFeatures];
        for (int i = 0; i < numCoeffs; ++i) {
            this.featureDescriptions[i] = i < 9 ? "mfcc0" + (i + 1) : "mfcc" + (i + 1);
        }
    }

    @Override
    public void setNumberOfFeatures(int num) {
        super.setNumberOfFeatures(num);
        this.inputLength = -1;
    }

    private void setupDCTcoeffs() {
        double m = Math.sqrt(2.0 / (double)this.inputLength);
        this.DCTcoeffs = new double[this.inputLength][((float[])this.features).length];
        for (int i = 0; i < this.inputLength; ++i) {
            for (int j = 0; j < ((float[])this.features).length; ++j) {
                this.DCTcoeffs[i][j] = m * Math.cos(Math.PI * (double)(j + 1) * ((double)i + 0.5) / (double)this.inputLength);
            }
        }
    }

    @Override
    public void process(TimeStamp startTime, TimeStamp endTime, float[] melSpectrum) {
        Arrays.fill((float[])this.features, 0.0f);
        float[] melSpectrumCopy = new float[melSpectrum.length];
        for (int i = 0; i < melSpectrum.length; ++i) {
            melSpectrumCopy[i] = melSpectrum[i];
        }
        if (melSpectrum.length != this.inputLength) {
            this.inputLength = melSpectrum.length;
            this.setupDCTcoeffs();
        }
        for (int x = 0; x < melSpectrumCopy.length; ++x) {
            melSpectrumCopy[x] = melSpectrumCopy[x] / 10.0f;
            for (int y = 0; y < ((float[])this.features).length; ++y) {
                float[] fArray = (float[])this.features;
                int n = y;
                fArray[n] = fArray[n] + (float)(this.DCTcoeffs[x][y] * (double)melSpectrumCopy[x]);
            }
        }
        this.forward(startTime, endTime);
    }
}

