/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.analysis.featureextractors;

import java.util.ArrayList;
import java.util.List;
import net.beadsproject.beads.analysis.FeatureExtractor;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.analysis.SegmentMaker;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.BeadArray;
import net.beadsproject.beads.core.TimeStamp;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.buffers.MeanFilter;

public class PeakDetector
extends FeatureExtractor<Float, Float>
implements SegmentMaker {
    private BeadArray listeners = new BeadArray();
    private List<SegmentListener> segmentListeners = new ArrayList<SegmentListener>();
    private TimeStamp lastStartTime;
    private double resetDelay = 100.0;
    private float valueAtOnset = 0.0f;
    private float threshold = 0.0f;
    private float baseThreshold = 0.1f;
    private float[] lastValues = new float[13];
    private Buffer filter = new MeanFilter().generateBuffer(13);
    private final int W = 3;
    private final int WM = 3;
    private final int M = 13;
    private float alpha = 0.9f;

    public void setThreshold(float thresh) {
        this.baseThreshold = thresh;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setResetDelay(float resetDelay) {
        this.resetDelay = resetDelay;
    }

    public float getLastOnsetValue() {
        return this.valueAtOnset;
    }

    public int getLagInFrames() {
        return 3;
    }

    public int getBufferSize() {
        return 13;
    }

    public void setFilter(Buffer b) {
        assert (b.buf.length == 13);
        this.filter = b;
    }

    @Override
    public void process(TimeStamp startTime, TimeStamp endTime, Float input) {
        if (this.lastStartTime == null) {
            this.lastStartTime = startTime;
        }
        for (int i = 1; i < 13; ++i) {
            this.lastValues[i - 1] = this.lastValues[i];
        }
        this.lastValues[12] = input.floatValue();
        float lastValue = this.lastValues[9];
        if (lastValue > this.threshold && endTime.since(this.lastStartTime) > this.resetDelay) {
            boolean passedTest2 = true;
            for (int i = 6; i <= 12; ++i) {
                if (i == 9 || !(lastValue < this.lastValues[i])) continue;
                passedTest2 = false;
            }
            if (passedTest2) {
                float average = 0.0f;
                for (int i = 1; i < 13; ++i) {
                    average += this.lastValues[i] * this.filter.buf[i];
                }
                if (lastValue > (average += input.floatValue() * this.filter.buf[12]) + this.baseThreshold) {
                    this.valueAtOnset = lastValue;
                    this.features = Float.valueOf(this.valueAtOnset);
                    this.forward(startTime, endTime);
                    for (SegmentListener sl : this.segmentListeners) {
                        sl.newSegment(this.lastStartTime, endTime);
                    }
                    this.listeners.message(this);
                    this.lastStartTime = endTime;
                }
            }
        }
        this.threshold = Math.max(lastValue, this.alpha * this.threshold + (1.0f - this.alpha) * lastValue);
    }

    public void addMessageListener(Bead b) {
        this.listeners.add(b);
    }

    public void removeMessageListener(Bead b) {
        this.listeners.remove(b);
    }

    @Override
    public void addSegmentListener(SegmentListener sl) {
        this.segmentListeners.add(sl);
    }

    @Override
    public void removeSegmentListener(SegmentListener sl) {
        this.segmentListeners.remove(sl);
    }
}

