/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Random;

public final class AudioUtils {
    public static Random rng = new Random();

    public static final void shortToFloat(float[] out, short[] in) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = (float)((double)in[i] / 32768.0);
        }
    }

    public static final void floatToShort(short[] out, float[] in) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = (short)(32767.0 * (double)in[i]);
        }
    }

    public static final void floatToByte(byte[] out, float[] in, boolean bigEndian) {
        AudioUtils.floatToByte(out, 0, in, 0, in.length, bigEndian);
    }

    public static final void floatToByte(byte[] out, int outstart, float[] in, int instart, int inlength, boolean bigEndian) {
        int bufsz = Math.min(inlength, in.length);
        int ib = outstart;
        if (bigEndian) {
            for (int i = 0; i < bufsz; ++i) {
                short y = (short)(32767.0 * (double)Math.min(Math.max(in[i + instart], -1.0f), 1.0f));
                out[ib++] = (byte)(y >> 8 & 0xFF);
                out[ib++] = (byte)(y & 0xFF);
            }
        } else {
            for (int i = 0; i < bufsz; ++i) {
                short y = (short)(32767.0 * (double)in[i + instart]);
                out[ib++] = (byte)(y & 0xFF);
                out[ib++] = (byte)(y >> 8 & 0xFF);
            }
        }
    }

    public static final void byteToFloat(float[] out, byte[] in, boolean bigEndian) {
        AudioUtils.byteToFloat(out, in, bigEndian, out.length);
    }

    public static final void byteToFloat(float[] out, byte[] in, boolean bigEndian, int numFloats) {
        AudioUtils.byteToFloat(out, in, bigEndian, 0, numFloats);
    }

    public static final void byteToFloat(float[] out, byte[] in, boolean bigEndian, int startIndexInByteArray, int numFloats) {
        AudioUtils.byteToFloat(out, in, bigEndian, startIndexInByteArray, 0, numFloats);
    }

    public static final void byteToFloat(float[] out, byte[] in, boolean bigEndian, int startIndexInByteArray, int startIndexInFloatArray, int numFloats) {
        if (bigEndian) {
            int ib = startIndexInByteArray;
            int min = Math.min(out.length, startIndexInFloatArray + numFloats);
            for (int i = startIndexInFloatArray; i < min; ++i) {
                float sample = (float)(in[ib + 0] << 8 | in[ib + 1] & 0xFF) / 32768.0f;
                ib += 2;
                out[i] = sample;
            }
        } else {
            int ib = startIndexInByteArray;
            int min = Math.min(out.length, startIndexInFloatArray + numFloats);
            for (int i = startIndexInFloatArray; i < min; ++i) {
                float sample = (float)(in[ib] & 0xFF | in[ib + 1] << 8) / 32768.0f;
                ib += 2;
                out[i] = sample;
            }
        }
    }

    public static final void deinterleave(float[] source, int nChannels, int nFrames, float[][] result) {
        int count = 0;
        for (int i = 0; i < nFrames; ++i) {
            for (int j = 0; j < nChannels; ++j) {
                result[j][i] = source[count++];
            }
        }
    }

    public static final void interleave(float[][] source, int nChannels, int nFrames, float[] result) {
        int counter = 0;
        for (int i = 0; counter < result.length && i < nFrames; ++i) {
            for (int j = 0; j < nChannels; ++j) {
                result[counter++] = source[j][i];
            }
        }
    }

    public static final void interleave(float[][] source, int nChannels, int nFrames, int offset, float[] result) {
        int counter = 0;
        for (int i = offset; counter < result.length && i < nFrames; ++i) {
            for (int j = 0; j < nChannels; ++j) {
                result[counter++] = source[j][i];
            }
        }
    }

    public static final void stretchBuffer(float[][] source, float[][] dest) {
        int numChannels = Math.min(source.length, dest.length);
        double segStep = ((double)source[0].length - 1.0) / ((double)dest[0].length - 1.0);
        for (int ch = 0; ch < numChannels; ++ch) {
            float[] src = source[ch];
            float[] dst = dest[ch];
            if (src.length == 1 || dst.length == 1) {
                dst[0] = src[0];
                continue;
            }
            dst[0] = src[0];
            dst[dst.length - 1] = src[src.length - 1];
            int segment = -1;
            double segstart = 0.0;
            double segend = 0.0;
            double seggrad = 0.0;
            double fractionalSegment = 0.0;
            for (int i = 1; i < dst.length - 1; ++i) {
                int currentSegment = (int)Math.floor(fractionalSegment += segStep);
                if (currentSegment != segment) {
                    segment = currentSegment;
                    segstart = src[segment];
                    segend = src[segment + 1];
                    seggrad = segend - segstart;
                }
                dst[i] = (float)(segstart + seggrad * (fractionalSegment - (double)currentSegment));
            }
        }
    }

    public static final void reverseBuffer(float[][] buffer) {
        for (float[] b : buffer) {
            int left = 0;
            for (int right = b.length - 1; left < right; ++left, --right) {
                float temp = b[left];
                b[left] = b[right];
                b[right] = temp;
            }
        }
    }

    public static double fastPow01(double a, double b) {
        double realA = Math.max(0.0, Math.min(1.0, a));
        int x = (int)(Double.doubleToLongBits(realA) >> 32);
        int y = (int)(b * (double)(x - 1072632447) + 1.072632447E9);
        return Math.max(0.0, Math.min(1.0, Double.longBitsToDouble((long)y << 32)));
    }

    public static URL urlFromString(String s) {
        URL url = null;
        url = ClassLoader.getSystemResource(s);
        if (url != null) {
            return url;
        }
        try {
            url = new URL(s);
        }
        catch (Exception e) {
            File f = new File(s);
            try {
                url = f.toURI().toURL();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
        return url;
    }

    public static File fileFromURL(URL url) {
        File theDirectory = null;
        try {
            theDirectory = new File(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return theDirectory;
    }

    public static File fileFromString(String s) {
        return AudioUtils.fileFromURL(AudioUtils.urlFromString(s));
    }
}

