/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

public abstract class Bead {
    private boolean paused = false;
    private boolean deleted = false;
    private Bead killListener;
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        String name = this.name;
        if (name != null) {
            return this.getClass().toString() + " name=" + name;
        }
        return this.getClass().toString();
    }

    public final void message(Bead message) {
        if (!this.paused) {
            this.messageReceived(message);
        }
    }

    protected void messageReceived(Bead message) {
    }

    public void start() {
        this.paused = false;
    }

    public void kill() {
        if (!this.deleted) {
            this.deleted = true;
            Bead killListener = this.killListener;
            if (killListener != null) {
                killListener.message(this);
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause(boolean paused) {
        this.paused = paused;
    }

    public void setKillListener(Bead killListener) {
        this.killListener = killListener;
    }

    public Bead getKillListener() {
        return this.killListener;
    }

    public boolean isDeleted() {
        return this.deleted;
    }
}

