/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

import net.beadsproject.beads.core.AudioContext;

public class TimeStamp {
    public final AudioContext context;
    public final long timeStep;
    public final int index;
    private double timeMs;
    private long timeSamples;

    public TimeStamp(AudioContext context, long timeStep, int index) {
        this.context = context;
        this.timeStep = timeStep;
        this.index = index;
    }

    public TimeStamp(AudioContext context, long timeInSamples) {
        this.context = context;
        this.timeStep = timeInSamples / (long)context.getBufferSize();
        this.index = (int)(timeInSamples % (long)context.getBufferSize());
    }

    public double getTimeMS() {
        this.timeMs = this.context.samplesToMs(this.getTimeSamples());
        return this.timeMs;
    }

    public long getTimeSamples() {
        this.timeSamples = this.timeStep * (long)this.context.getBufferSize() + (long)this.index;
        return this.timeSamples;
    }

    public double since(TimeStamp oldest) {
        return this.getTimeMS() - oldest.getTimeMS();
    }

    public boolean isBefore(TimeStamp other) {
        if (this.timeStep < other.timeStep) {
            return true;
        }
        return this.timeStep == other.timeStep && this.timeSamples < other.timeSamples;
    }

    public boolean isAfter(TimeStamp other) {
        if (this.timeStep > other.timeStep) {
            return true;
        }
        return this.timeStep == other.timeStep && this.timeSamples > other.timeSamples;
    }

    public String toString() {
        return this.timeStep + "-" + this.index;
    }

    public static TimeStamp subtract(AudioContext ac, TimeStamp a, TimeStamp b) {
        return new TimeStamp(ac, a.getTimeSamples() - b.getTimeSamples());
    }

    public static TimeStamp add(AudioContext ac, TimeStamp a, TimeStamp b) {
        return new TimeStamp(ac, a.getTimeSamples() + b.getTimeSamples());
    }
}

