/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.events.KillTrigger;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Gain;

public abstract class UGen
extends Bead {
    protected AudioContext context;
    protected int ins;
    protected int outs;
    protected float[][] bufIn;
    protected float[][] bufOut;
    protected int bufferSize;
    private ArrayList<BufferPointer>[] inputsAtChannel;
    private ArrayList<UGen> dependents = new ArrayList();
    private boolean noInputs = true;
    private long lastTimeStep = -1L;
    private boolean timerMode = false;
    private long timeTakenLastUpdate;
    private long timeTemp = 0L;
    protected OutputInitializationRegime outputInitializationRegime = OutputInitializationRegime.JUNK;
    protected OutputPauseRegime outputPauseRegime = OutputPauseRegime.ZERO;
    private static Hashtable<Class<?>, Hashtable<String, Method>> envelopeGetterMethods = new Hashtable();

    public UGen(AudioContext context) {
        this(context, 0, 0);
    }

    public UGen(AudioContext context, int outs) {
        this(context, 0, outs);
    }

    public UGen(AudioContext context, int ins, int outs) {
        this.setIns(ins);
        this.setOuts(outs);
        this.setContext(context);
    }

    private void setContext(AudioContext context) {
        this.context = context;
        if (context != null) {
            this.bufferSize = context.getBufferSize();
            this.setupInputBuffer();
            this.setupOutputBuffer();
            this.zeroIns();
            this.zeroOuts();
        } else {
            this.bufIn = null;
            this.bufOut = null;
        }
    }

    public AudioContext getContext() {
        return this.context;
    }

    private synchronized void setIns(int ins) {
        this.ins = ins;
        this.inputsAtChannel = new ArrayList[ins];
        for (int i = 0; i < ins; ++i) {
            this.inputsAtChannel[i] = new ArrayList();
        }
    }

    public int getIns() {
        return this.ins;
    }

    private void setOuts(int outs) {
        this.outs = outs;
    }

    public int getOuts() {
        return this.outs;
    }

    private void setupInputBuffer() {
        this.bufIn = new float[this.ins][];
    }

    private void setupOutputBuffer() {
        this.bufOut = new float[this.outs][];
    }

    public void zeroOuts() {
        for (int i = 0; i < this.outs; ++i) {
            this.bufOut[i] = this.context.getZeroBuf();
        }
    }

    public void zeroIns() {
        for (int i = 0; i < this.ins; ++i) {
            this.bufIn[i] = this.context.getZeroBuf();
        }
    }

    protected void setOutsToPause() {
        switch (this.outputPauseRegime) {
            case ZERO: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = this.context.getZeroBuf();
                }
                break;
            }
            case RETAIN: {
                break;
            }
            case NULL: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = null;
                }
                break;
            }
        }
    }

    protected void initializeOuts() {
        switch (this.outputInitializationRegime) {
            case JUNK: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = this.context.getBuf();
                }
                break;
            }
            case ZERO: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = this.context.getCleanBuf();
                }
                break;
            }
            case NULL: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = null;
                }
                break;
            }
            case RETAIN: {
                break;
            }
            default: {
                for (int i = 0; i < this.outs; ++i) {
                    this.bufOut[i] = null;
                }
            }
        }
    }

    private synchronized void pullInputs() {
        block11: {
            int i;
            block10: {
                int size = this.dependents.size();
                for (int index = 0; index < size; ++index) {
                    UGen dependent = this.dependents.get(index);
                    if (dependent.isDeleted()) {
                        this.dependents.remove(index);
                        --index;
                        --size;
                        continue;
                    }
                    dependent.update();
                }
                if (this.noInputs) break block10;
                this.noInputs = true;
                for (i = 0; i < this.inputsAtChannel.length; ++i) {
                    size = this.inputsAtChannel[i].size();
                    this.bufIn[i] = this.context.getZeroBuf();
                    if (size == 1) {
                        BufferPointer bp = this.inputsAtChannel[i].get(0);
                        if (bp.ugen.isDeleted()) {
                            this.removeInputAtChannel(i, bp);
                            continue;
                        }
                        bp.ugen.update();
                        this.noInputs = false;
                        this.bufIn[i] = bp.getBuffer();
                        if (this.bufIn[i] != null) continue;
                        this.bufIn[i] = this.context.getBuf();
                        float[] bi = this.bufIn[i];
                        for (int j = 0; j < this.bufferSize; ++j) {
                            bi[j] = bp.get(j);
                        }
                        continue;
                    }
                    if (size == 0) continue;
                    this.bufIn[i] = this.context.getCleanBuf();
                    float[] bi = this.bufIn[i];
                    for (int index = 0; index < size; ++index) {
                        BufferPointer bp = this.inputsAtChannel[i].get(index);
                        if (bp.ugen.isDeleted()) {
                            this.removeInputAtChannel(i, bp);
                            --size;
                            --index;
                            continue;
                        }
                        bp.ugen.update();
                        this.noInputs = false;
                        for (int j = 0; j < this.bufferSize; ++j) {
                            int n = j;
                            bi[n] = bi[n] + bp.get(j);
                        }
                    }
                }
                break block11;
            }
            if (this.ins == 0) break block11;
            for (i = 0; i < this.inputsAtChannel.length; ++i) {
                this.bufIn[i] = this.context.getZeroBuf();
            }
        }
    }

    public void update() {
        if (!this.isPaused()) {
            if (!this.isUpdated()) {
                if (this.timerMode) {
                    this.timeTemp = System.nanoTime();
                }
                this.lastTimeStep = this.context.getTimeStep();
                this.pullInputs();
                this.initializeOuts();
                this.calculateBuffer();
                if (this.timerMode) {
                    this.timeTakenLastUpdate = System.nanoTime() - this.timeTemp;
                }
            }
            if (this.isPaused()) {
                this.setOutsToPause();
            }
        }
    }

    public void printInputList() {
        for (int i = 0; i < this.inputsAtChannel.length; ++i) {
            System.out.print(this.inputsAtChannel[i].size() + " inputs: ");
            for (BufferPointer bp : this.inputsAtChannel[i]) {
                System.out.print(bp.ugen + ":" + bp.index + " ");
            }
            System.out.println();
        }
    }

    public synchronized void addInput(UGen sourceUGen) {
        if (this.ins != 0 && sourceUGen.outs != 0) {
            for (int i = 0; i < this.ins; ++i) {
                this.addInput(i, sourceUGen, i % sourceUGen.outs);
            }
        }
    }

    public synchronized void addInput(int inputIndex, UGen sourceUGen, int sourceOutputIndex) {
        this.inputsAtChannel[inputIndex].add(new BufferPointer(sourceUGen, sourceOutputIndex));
        this.noInputs = false;
    }

    public synchronized void crossfadeInput(UGen source, final UGen destination, float crossoverTime) {
        this.removeAllConnections(source);
        Envelope fadeOut = new Envelope(this.context, 1.0f);
        Gain gOut = new Gain(this.context, source.outs, fadeOut);
        fadeOut.addSegment(0.0f, crossoverTime, new KillTrigger(gOut));
        gOut.addInput(source);
        this.addInput(gOut);
        Envelope fadeIn = new Envelope(this.context, 0.0f);
        final Gain gIn = new Gain(this.context, destination.outs, fadeIn);
        fadeIn.addSegment(1.0f, crossoverTime, new Bead(){

            @Override
            public void messageReceived(Bead message) {
                UGen.this.removeAllConnections(gIn);
                UGen.this.addInput(destination);
            }
        });
        gIn.addInput(source);
        this.addInput(gIn);
    }

    public synchronized void addDependent(UGen dependent) {
        this.dependents.add(dependent);
    }

    public synchronized void removeDependent(UGen dependent) {
        this.dependents.remove(dependent);
    }

    public synchronized void clearDependents() {
        this.dependents.clear();
    }

    public synchronized int getNumberOfConnectedUGens(int index) {
        return this.inputsAtChannel[index].size();
    }

    public synchronized int getNumberOfDependents() {
        return this.dependents.size();
    }

    public synchronized boolean containsInput(UGen ugen) {
        if (this.noInputs) {
            return false;
        }
        for (int i = 0; i < this.inputsAtChannel.length; ++i) {
            ArrayList bplist = (ArrayList)this.inputsAtChannel[i].clone();
            for (BufferPointer bp : bplist) {
                if (!ugen.equals(bp.ugen)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized Set<UGen> getConnectedInputs() {
        HashSet<UGen> connectedInputs = new HashSet<UGen>();
        for (int i = 0; i < this.ins; ++i) {
            for (BufferPointer bp : this.inputsAtChannel[i]) {
                connectedInputs.add(bp.ugen);
            }
        }
        return connectedInputs;
    }

    private void findEnvelopeGetterMethods() {
        Class<?> c = this.getClass();
        if (!envelopeGetterMethods.containsKey(c)) {
            Method[] methods;
            Hashtable<String, Method> methodTable = new Hashtable<String, Method>();
            for (Method m : methods = c.getMethods()) {
                String name = m.getName();
                if (!name.startsWith("get") || !name.endsWith("UGen") || !m.getReturnType().equals(UGen.class)) continue;
                String envelopeName = name.substring(3, 3).toLowerCase() + name.substring(4, name.length() - 8);
                methodTable.put(envelopeName, m);
            }
            envelopeGetterMethods.put(c, methodTable);
        }
    }

    public synchronized Map<String, UGen> getEnvelopes() {
        Hashtable<String, UGen> envelopes = new Hashtable<String, UGen>();
        this.findEnvelopeGetterMethods();
        Hashtable<String, Method> methodTable = envelopeGetterMethods.get(this.getClass());
        for (String s : methodTable.keySet()) {
            Method m = methodTable.get(s);
            try {
                envelopes.put(s, (UGen)m.invoke((Object)this, new Object[0]));
            }
            catch (Exception exception) {}
        }
        return envelopes;
    }

    private synchronized void removeInputAtChannel(int channel, BufferPointer bp) {
        this.inputsAtChannel[channel].remove(bp);
    }

    public synchronized void removeAllConnections(UGen sourceUGen) {
        if (!this.noInputs) {
            int inputCount = 0;
            for (int i = 0; i < this.inputsAtChannel.length; ++i) {
                ArrayList bplist = (ArrayList)this.inputsAtChannel[i].clone();
                for (BufferPointer bp : bplist) {
                    if (sourceUGen.equals(bp.ugen)) {
                        this.removeInputAtChannel(i, bp);
                        continue;
                    }
                    ++inputCount;
                }
            }
            if (inputCount == 0) {
                this.noInputs = true;
                this.zeroIns();
            }
        }
    }

    public synchronized boolean removeConnection(int inputChannel, UGen sourceUGen, int sourceOutputChannel) {
        if (!this.noInputs) {
            int inputCount = 0;
            boolean ret = false;
            ArrayList bplist = (ArrayList)this.inputsAtChannel[inputChannel].clone();
            for (BufferPointer bp : bplist) {
                if (sourceUGen.equals(bp.ugen) && bp.index == sourceOutputChannel) {
                    this.removeInputAtChannel(inputChannel, bp);
                    ret = true;
                    continue;
                }
                ++inputCount;
            }
            if (inputCount == 0) {
                this.noInputs = true;
                this.zeroIns();
            }
            return ret;
        }
        return false;
    }

    public synchronized void clearInputConnections() {
        for (int i = 0; i < this.inputsAtChannel.length; ++i) {
            ArrayList bplist = (ArrayList)this.inputsAtChannel[i].clone();
            for (BufferPointer bp : bplist) {
                this.removeInputAtChannel(i, bp);
            }
            this.noInputs = true;
            this.zeroIns();
        }
    }

    public void printInBuffers() {
        for (int i = 0; i < this.bufferSize; ++i) {
            System.out.print(this + " " + i + " ");
            for (int j = 0; j < this.ins; ++j) {
                System.out.print(this.bufIn[j][i] + " ");
            }
            System.out.println();
        }
    }

    public void printOutBuffers() {
        for (int i = 0; i < this.bufferSize; ++i) {
            System.out.print(this + " " + i + " ");
            for (int j = 0; j < this.outs; ++j) {
                System.out.print(this.bufOut[j][i] + " ");
            }
            System.out.println();
        }
    }

    public boolean noInputs() {
        return this.noInputs;
    }

    public abstract void calculateBuffer();

    public float getValue(int i, int j) {
        return this.bufOut[i][j];
    }

    public float[] getOutBuffer(int i) {
        return this.bufOut[i];
    }

    public float getValue() {
        return this.getValue(0, 0);
    }

    public double getValueDouble(int i, int j) {
        return this.getValue(i, j);
    }

    public double getValueDouble() {
        return this.getValue();
    }

    public void setValue(float value) {
    }

    public boolean isUpdated() {
        return this.lastTimeStep == this.context.getTimeStep();
    }

    @Override
    public void pause(boolean paused) {
        if (!this.isPaused() && paused) {
            this.setOutsToPause();
        }
        super.pause(paused);
    }

    public boolean isTimerMode() {
        return this.timerMode;
    }

    public void setTimerMode(boolean timerMode) {
        this.timerMode = timerMode;
    }

    public long getTimeTakenLastUpdate() {
        return this.timeTakenLastUpdate;
    }

    private class BufferPointer {
        final UGen ugen;
        final int index;

        BufferPointer(UGen ugen, int index) {
            this.ugen = ugen;
            this.index = index;
        }

        float[] getBuffer() {
            return this.ugen.bufOut[this.index];
        }

        float get(int point) {
            return this.ugen.getValue(this.index, point);
        }
    }

    protected static enum OutputPauseRegime {
        ZERO,
        RETAIN,
        NULL;

    }

    protected static enum OutputInitializationRegime {
        ZERO,
        NULL,
        JUNK,
        RETAIN;

    }
}

