/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.core.io;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.AudioIO;
import net.beadsproject.beads.core.AudioUtils;
import net.beadsproject.beads.core.IOAudioFormat;
import net.beadsproject.beads.core.UGen;

public class JavaSoundAudioIO
extends AudioIO {
    public static final int DEFAULT_SYSTEM_BUFFER_SIZE = 5000;
    private Mixer mixer;
    private SourceDataLine sourceDataLine;
    private int systemBufferSizeInFrames;
    private Thread audioThread;
    private int threadPriority;
    private byte[] bbuf;

    public JavaSoundAudioIO() {
        this(5000);
    }

    public JavaSoundAudioIO(int systemBufferSize) {
        this.systemBufferSizeInFrames = systemBufferSize;
        this.setThreadPriority(10);
    }

    public boolean create() {
        IOAudioFormat ioAudioFormat = this.getContext().getAudioFormat();
        AudioFormat audioFormat = new AudioFormat(ioAudioFormat.sampleRate, ioAudioFormat.bitDepth, ioAudioFormat.outputs, ioAudioFormat.signed, ioAudioFormat.bigEndian);
        this.getDefaultMixerIfNotAlreadyChosen();
        if (this.mixer == null) {
            return false;
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            this.sourceDataLine = (SourceDataLine)this.mixer.getLine(info);
            if (this.systemBufferSizeInFrames < 0) {
                this.sourceDataLine.open(audioFormat);
            } else {
                this.sourceDataLine.open(audioFormat, this.systemBufferSizeInFrames * audioFormat.getFrameSize());
            }
        }
        catch (LineUnavailableException ex) {
            System.out.println(this.getClass().getName() + " : Error getting line\n");
        }
        return true;
    }

    private void getDefaultMixerIfNotAlreadyChosen() {
        if (this.mixer == null) {
            this.selectMixer(0);
        }
    }

    public void chooseMixerCommandLine() {
        System.out.println("Choose a mixer...");
        JavaSoundAudioIO.printMixerInfo();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            this.selectMixer(Integer.parseInt(br.readLine()) - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectMixer(int i) {
        Mixer.Info[] mixerinfo = AudioSystem.getMixerInfo();
        this.mixer = AudioSystem.getMixer(mixerinfo[i]);
        if (this.mixer != null) {
            System.out.print("JavaSoundAudioIO: Chosen mixer is ");
            System.out.println(this.mixer.getMixerInfo().getName() + ".");
        } else {
            System.out.println("JavaSoundAudioIO: Failed to get mixer.");
        }
    }

    public static void printMixerInfo() {
        Mixer.Info[] mixerinfo = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixerinfo.length; ++i) {
            String name = mixerinfo[i].getName();
            if (name.equals("")) {
                name = "No name";
            }
            System.out.println(i + 1 + ") " + name + " --- " + mixerinfo[i].getDescription());
            Mixer m = AudioSystem.getMixer(mixerinfo[i]);
            Line.Info[] lineinfo = m.getSourceLineInfo();
            for (int j = 0; j < lineinfo.length; ++j) {
                System.out.println("  - " + lineinfo[j].toString());
            }
        }
    }

    public void setThreadPriority(int priority) {
        this.threadPriority = priority;
        if (this.audioThread != null) {
            this.audioThread.setPriority(this.threadPriority);
        }
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    protected boolean destroy() {
        this.sourceDataLine.drain();
        this.sourceDataLine.stop();
        this.sourceDataLine.close();
        this.sourceDataLine = null;
        this.mixer.close();
        this.mixer = null;
        return true;
    }

    @Override
    protected boolean start() {
        this.audioThread = new Thread(new Runnable(){

            @Override
            public void run() {
                JavaSoundAudioIO.this.create();
                JavaSoundAudioIO.this.runRealTime();
                JavaSoundAudioIO.this.destroy();
            }
        });
        this.audioThread.setPriority(this.threadPriority);
        this.audioThread.start();
        return true;
    }

    private void runRealTime() {
        AudioContext context = this.getContext();
        IOAudioFormat ioAudioFormat = this.getContext().getAudioFormat();
        AudioFormat audioFormat = new AudioFormat(ioAudioFormat.sampleRate, ioAudioFormat.bitDepth, ioAudioFormat.outputs, ioAudioFormat.signed, ioAudioFormat.bigEndian);
        int bufferSizeInFrames = context.getBufferSize();
        this.bbuf = new byte[bufferSizeInFrames * audioFormat.getFrameSize()];
        float[] interleavedOutput = new float[audioFormat.getChannels() * bufferSizeInFrames];
        this.sourceDataLine.start();
        while (context.isRunning()) {
            this.update();
            int counter = 0;
            for (int i = 0; i < bufferSizeInFrames; ++i) {
                for (int j = 0; j < audioFormat.getChannels(); ++j) {
                    interleavedOutput[counter++] = context.out.getValue(j, i);
                }
            }
            AudioUtils.floatToByte(this.bbuf, interleavedOutput, audioFormat.isBigEndian());
            this.sourceDataLine.write(this.bbuf, 0, this.bbuf.length);
        }
    }

    @Override
    protected UGen getAudioInput(int[] channels) {
        IOAudioFormat ioAudioFormat = this.getContext().getAudioFormat();
        AudioFormat audioFormat = new AudioFormat(ioAudioFormat.sampleRate, ioAudioFormat.bitDepth, ioAudioFormat.inputs, ioAudioFormat.signed, ioAudioFormat.bigEndian);
        return new JavaSoundRTInput(this.getContext(), audioFormat);
    }

    private class JavaSoundRTInput
    extends UGen {
        private AudioFormat audioFormat;
        private TargetDataLine targetDataLine;
        private boolean javaSoundInitialized;
        private float[] interleavedSamples;
        private byte[] bbuf;

        JavaSoundRTInput(AudioContext context, AudioFormat audioFormat) {
            super(context, audioFormat.getChannels());
            this.audioFormat = audioFormat;
            this.javaSoundInitialized = false;
        }

        public void initJavaSound() {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            try {
                int inputBufferSize = 5000;
                this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
                this.targetDataLine.open(this.audioFormat, inputBufferSize);
                if (this.targetDataLine == null) {
                    System.out.println("no line");
                } else {
                    System.out.println("CHOSEN INPUT: " + this.targetDataLine.getLineInfo() + ", buffer size in bytes: " + inputBufferSize);
                }
            }
            catch (LineUnavailableException ex) {
                System.out.println(this.getClass().getName() + " : Error getting line\n");
            }
            this.targetDataLine.start();
            this.javaSoundInitialized = true;
            this.interleavedSamples = new float[this.bufferSize * this.audioFormat.getChannels()];
            this.bbuf = new byte[this.bufferSize * this.audioFormat.getFrameSize()];
        }

        @Override
        public void calculateBuffer() {
            if (!this.javaSoundInitialized) {
                this.initJavaSound();
            }
            this.targetDataLine.read(this.bbuf, 0, this.bbuf.length);
            AudioUtils.byteToFloat(this.interleavedSamples, this.bbuf, this.audioFormat.isBigEndian());
            AudioUtils.deinterleave(this.interleavedSamples, this.audioFormat.getChannels(), this.bufferSize, this.bufOut);
        }
    }
}

