/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data;

import java.io.Serializable;
import java.util.Hashtable;
import net.beadsproject.beads.data.buffers.NoiseBuffer;
import net.beadsproject.beads.data.buffers.SawBuffer;
import net.beadsproject.beads.data.buffers.SineBuffer;
import net.beadsproject.beads.data.buffers.SquareBuffer;
import net.beadsproject.beads.data.buffers.TriangleBuffer;

public class Buffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Hashtable<String, Buffer> staticBufs = new Hashtable();
    public static final Buffer SINE = new SineBuffer().getDefault();
    public static final Buffer SAW = new SawBuffer().getDefault();
    public static final Buffer SQUARE = new SquareBuffer().getDefault();
    public static final Buffer TRIANGLE = new TriangleBuffer().getDefault();
    public static final Buffer NOISE = new NoiseBuffer().getDefault();
    public final float[] buf;

    public Buffer(int size) {
        this.buf = new float[size];
    }

    public float getValueFraction(float fraction) {
        float posInBuf = fraction * (float)this.buf.length;
        int lowerIndex = (int)posInBuf;
        float offset = posInBuf - (float)lowerIndex;
        int upperIndex = (lowerIndex + 1) % this.buf.length;
        return (1.0f - offset) * this.getValueIndex(lowerIndex) + offset * this.getValueIndex(upperIndex);
    }

    public float getValueFractionNoInterp(float fraction) {
        return this.getValueIndex((int)(fraction * (float)this.buf.length));
    }

    public float getValueIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index >= this.buf.length) {
            index = this.buf.length - 1;
        }
        return this.buf[index];
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this.buf.length; ++i) {
            b.append(this.buf[i] + " ");
        }
        return b.toString();
    }
}

