/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBeadReceiver;

public class DataBead
extends Bead
implements Map<String, Object> {
    public Map<String, Object> properties;

    public DataBead() {
        this.properties = new Hashtable<String, Object>();
    }

    public DataBead(String key, Object val) {
        this.properties = new Hashtable<String, Object>();
        if (key != null) {
            this.properties.put(key, val);
        }
    }

    public DataBead(String[] proparr, Object[] valarr) {
        this.properties = new Hashtable<String, Object>();
        if (proparr != null && valarr != null) {
            int s = Math.min(proparr.length, valarr.length);
            for (int i = 0; i < s; ++i) {
                if (proparr[i] == null) continue;
                this.properties.put(proparr[i], valarr[i]);
            }
        }
    }

    public DataBead(Map<String, Object> ht) {
        this.properties = ht == null ? new Hashtable<String, Object>() : ht;
    }

    public DataBead(Object ... objects) {
        this.properties = new Hashtable<String, Object>();
        this.putAll(objects);
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.putAll((Map<? extends String, ? extends Object>)((DataBead)message).properties);
        }
    }

    public void putAll(DataBead db) {
        this.putAll((Map<? extends String, ? extends Object>)db.properties);
    }

    public void putAll(Object ... objects) {
        for (int i = 0; i < objects.length; i += 2) {
            this.put((String)objects[i], objects[i + 1]);
        }
    }

    public void configureObject(Object o) {
        if (o instanceof DataBeadReceiver) {
            ((DataBeadReceiver)o).sendData(this);
        } else {
            for (String s : this.properties.keySet()) {
                String methodName = "set" + s.substring(0, 1).toUpperCase() + s.substring(1);
                Object theArg = this.properties.get(s);
                try {
                    Method m = o.getClass().getMethod(methodName, theArg.getClass());
                    m.invoke(o, theArg);
                }
                catch (Exception exception) {}
            }
        }
    }

    public float getFloat(String key, float defaultVal) {
        Float ret = this.getFloatObject(key);
        if (ret == null) {
            return defaultVal;
        }
        return ret.floatValue();
    }

    public Float getFloatObject(String key) {
        Object o = this.get(key);
        if (o instanceof Number) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof String) {
            try {
                Float r = Float.valueOf(Float.parseFloat((String)o));
                return r;
            }
            catch (Exception exception) {}
        } else if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return Float.valueOf(1.0f);
            }
            return Float.valueOf(0.0f);
        }
        return null;
    }

    public UGen getUGen(String key) {
        Object o = this.get(key);
        if (o instanceof UGen) {
            return (UGen)o;
        }
        return null;
    }

    public float[] getFloatArray(String key) {
        Object ret;
        Object o = this.get(key);
        if (o instanceof Number[]) {
            Number[] n = (Number[])o;
            ret = new float[n.length];
            for (int i = 0; i < n.length; ++i) {
                ret[i] = n[i].floatValue();
            }
        } else if (o instanceof float[]) {
            ret = (float[])o;
        } else if (o instanceof double[]) {
            double[] p = (double[])o;
            ret = new float[p.length];
            for (int i = 0; i < p.length; ++i) {
                ret[i] = (float)p[i];
            }
        } else if (o instanceof int[]) {
            int[] p = (int[])o;
            ret = new float[p.length];
            for (int i = 0; i < p.length; ++i) {
                ret[i] = p[i];
            }
        } else if (o instanceof long[]) {
            long[] p = (long[])o;
            ret = new float[p.length];
            for (int i = 0; i < p.length; ++i) {
                ret[i] = p[i];
            }
        } else if (o instanceof char[]) {
            char[] p = (char[])o;
            ret = new float[p.length];
            for (int i = 0; i < p.length; ++i) {
                ret[i] = p[i];
            }
        } else if (o instanceof byte[]) {
            byte[] p = (byte[])o;
            ret = new float[p.length];
            for (int i = 0; i < p.length; ++i) {
                ret[i] = p[i];
            }
        } else if (o instanceof short[]) {
            short[] p = (short[])o;
            ret = new float[p.length];
            for (int i = 0; i < p.length; ++i) {
                ret[i] = p[i];
            }
        } else if (o instanceof boolean[]) {
            boolean[] p = (boolean[])o;
            ret = new float[p.length];
            for (int i = 0; i < p.length; ++i) {
                ret[i] = p[i] ? 1.0f : 0.0f;
            }
        } else {
            ret = o instanceof Number ? new float[]{((Number)o).floatValue()} : null;
        }
        return ret;
    }

    public UGen[] getUGenArray(String key) {
        Object o = this.get(key);
        if (o instanceof UGen[]) {
            return (UGen[])o;
        }
        if (o instanceof UGen) {
            return new UGen[]{(UGen)o};
        }
        return null;
    }

    public DataBead clone() {
        DataBead ret = new DataBead();
        ret.setName(this.getName());
        ret.putAll((Map<? extends String, ? extends Object>)this.properties);
        return ret;
    }

    public static DataBead combine(DataBead a, DataBead b) {
        DataBead c = new DataBead();
        c.putAll(b);
        c.putAll(a);
        return c;
    }

    @Override
    public String toString() {
        return super.toString() + ":\n" + this.properties.toString();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.properties.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.properties.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public void clear() {
        this.properties.clear();
    }
}

