/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data;

public abstract class Pitch {
    public static final float LOG2 = 0.6931472f;
    public static final String[] pitchNames = new String[]{"C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B"};
    public static final int[] dorian = new int[]{0, 2, 3, 5, 7, 9, 10};
    public static final int[] major = new int[]{0, 2, 4, 5, 7, 9, 11};
    public static final int[] minor = new int[]{0, 2, 3, 5, 7, 8, 10};
    public static final int[] circleOfFifths = new int[]{0, 5, 10, 3, 8, 1, 6, 11, 4, 9, 2, 7};
    public static final int[] pentatonic = new int[]{0, 2, 4, 7, 9};

    public static final float ftom(float frequency) {
        return Math.max(0.0f, (float)Math.log(frequency / 440.0f) / 0.6931472f * 12.0f + 69.0f);
    }

    public static final float mtof(float midi) {
        return 440.0f * (float)Math.pow(2.0, (midi - 69.0f) / 12.0f);
    }

    public static final int forceToScale(int pitch, int[] scale, int notesPerOctave) {
        int pitchClass = pitch % notesPerOctave;
        int register = pitch / notesPerOctave;
        int newPitchClass = -1;
        for (int i = scale.length - 1; i >= 0; --i) {
            if (pitchClass < scale[i]) continue;
            newPitchClass = scale[i];
            break;
        }
        if (newPitchClass == -1) {
            newPitchClass = pitchClass;
        }
        return register * notesPerOctave + newPitchClass;
    }

    public static final int forceToScale(int pitch, int[] scale) {
        return Pitch.forceToScale(pitch, scale, 12);
    }

    public static final float forceFrequencyToScale(float freq, int[] scale) {
        return Pitch.mtof(Pitch.forceToScale((int)Pitch.ftom(freq), scale));
    }
}

