/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data.audiofile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.beadsproject.beads.core.AudioUtils;
import net.beadsproject.beads.data.SampleAudioFormat;
import net.beadsproject.beads.data.audiofile.AudioFileReader;
import net.beadsproject.beads.data.audiofile.AudioFileType;
import net.beadsproject.beads.data.audiofile.AudioFileWriter;
import net.beadsproject.beads.data.audiofile.OperationUnsupportedException;
import net.beadsproject.beads.data.audiofile.WavFileReaderWriter;

public class JavaSoundAudioFile
implements AudioFileReader,
AudioFileWriter {
    private File file;
    private URL url;
    private AudioInputStream audioInputStream;
    private String name;
    private boolean finished = false;
    private AudioFormat encodedFormat;
    private AudioFormat decodedFormat;
    private AudioInputStream encodedStream = null;
    private AudioInputStream decodedStream = null;
    private boolean isEncoded = false;
    private SampleAudioFormat audioFormat;
    private float[][] sampleData;
    private WavFileReaderWriter wavBackup = new WavFileReaderWriter();

    public static SampleAudioFormat convertJavasoundAudioFormatToBeadsAudioFormat(AudioFormat af) {
        boolean signed = af.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        SampleAudioFormat newaf = new SampleAudioFormat(af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), signed, af.isBigEndian());
        return newaf;
    }

    public static AudioFormat convertBeadsAudioFormatToJavasoundAudioFormat(SampleAudioFormat saf) {
        AudioFormat af = new AudioFormat(saf.sampleRate, saf.bitDepth, saf.channels, saf.signed, saf.bigEndian);
        return af;
    }

    @Override
    public void writeAudioFile(float[][] data, String filename, AudioFileType type, SampleAudioFormat saf) throws IOException, OperationUnsupportedException {
        if (!this.getSupportedFileTypesForWriting().contains((Object)type)) {
            throw new OperationUnsupportedException("Unsupported file type for writing: " + (Object)((Object)type));
        }
        if (saf.bitDepth > 16) {
            throw new OperationUnsupportedException("Unsupported bit depth. Javasound cannot write WAV or AIFF files with bit depth > 16.");
        }
        int chans = data.length;
        int frames = data[0].length;
        float[] interleaved = new float[chans * frames];
        AudioUtils.interleave(data, chans, frames, interleaved);
        byte[] bytes = new byte[chans * frames * saf.bitDepth / 8];
        AudioUtils.floatToByte(bytes, interleaved, saf.bigEndian);
        AudioFormat jsaf = new AudioFormat(saf.sampleRate, saf.bitDepth, saf.channels, saf.signed, saf.bigEndian);
        AudioFileFormat.Type jsType = AudioFileFormat.Type.WAVE;
        if (type == AudioFileType.AIFF) {
            jsType = AudioFileFormat.Type.AIFF;
        }
        AudioSystem.write(new AudioInputStream(new ByteArrayInputStream(bytes), jsaf, frames), jsType, new File(filename));
    }

    @Override
    public HashSet<AudioFileType> getSupportedFileTypesForWriting() {
        HashSet<AudioFileType> types = new HashSet<AudioFileType>();
        types.add(AudioFileType.WAV);
        types.add(AudioFileType.AIFF);
        return types;
    }

    @Override
    public float[][] readAudioFile(String name) throws IOException {
        try {
            this.url = new URL(name);
            this.file = null;
            this.name = this.url.getFile();
        }
        catch (Exception e) {
            this.file = new File(name);
            this.url = null;
            this.name = this.file.getAbsolutePath();
        }
        this.audioInputStream = null;
        try {
            this.prepareForReading();
            this.readEntireFile();
        }
        catch (Exception e) {
            throw new IOException("Could not read audio file: " + this.name);
        }
        this.close();
        return this.sampleData;
    }

    @Override
    public HashSet<AudioFileType> getSupportedFileTypesForReading() {
        HashSet<AudioFileType> types = new HashSet<AudioFileType>();
        types.add(AudioFileType.WAV);
        types.add(AudioFileType.AIFF);
        types.add(AudioFileType.MP3);
        return types;
    }

    private void prepareForReading() throws IOException {
        this.finished = false;
        try {
            this.encodedStream = this.getStream();
        }
        catch (UnsupportedAudioFileException e) {
            throw new IOException(e.getMessage());
        }
        this.encodedFormat = this.encodedStream.getFormat();
        int bitDepth = 16;
        this.decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.encodedFormat.getSampleRate(), bitDepth, this.encodedFormat.getChannels(), this.encodedFormat.getChannels() * (bitDepth / 8), 44100.0f, this.encodedFormat.isBigEndian());
        if (AudioSystem.isConversionSupported(this.decodedFormat, this.encodedFormat)) {
            this.isEncoded = true;
            this.decodedStream = AudioSystem.getAudioInputStream(this.decodedFormat, this.encodedStream);
        } else {
            this.isEncoded = false;
            this.decodedFormat = this.encodedFormat;
            this.decodedStream = this.encodedStream;
            if (this.decodedFormat.getFrameSize() != 2 * this.decodedFormat.getChannels()) {
                this.close();
                String s = "Tried to load " + 8 * this.decodedFormat.getFrameSize() / this.decodedFormat.getChannels() + "-bit file, but couldn't convert to 16-bit.";
                throw new IOException(s);
            }
        }
        this.audioFormat = JavaSoundAudioFile.convertJavasoundAudioFormatToBeadsAudioFormat(this.decodedFormat);
    }

    private void readEntireFile() throws IOException {
        byte[] newBuf;
        int bytesRead;
        int BUFFERSIZE = 4096;
        byte[] audioBytes = new byte[4096];
        int sampleBufferSize = 4096;
        byte[] data = new byte[sampleBufferSize];
        int totalBytesRead = 0;
        while ((bytesRead = this.read(audioBytes)) != -1) {
            if (bytesRead > sampleBufferSize - totalBytesRead) {
                sampleBufferSize = Math.max(sampleBufferSize * 2, sampleBufferSize + bytesRead);
                newBuf = new byte[sampleBufferSize];
                System.arraycopy(data, 0, newBuf, 0, data.length);
                data = newBuf;
            }
            System.arraycopy(audioBytes, 0, data, totalBytesRead, bytesRead);
            totalBytesRead += bytesRead;
        }
        if (sampleBufferSize > totalBytesRead) {
            sampleBufferSize = totalBytesRead;
            newBuf = new byte[sampleBufferSize];
            System.arraycopy(data, 0, newBuf, 0, sampleBufferSize);
            data = newBuf;
        }
        int nFrames = sampleBufferSize / (2 * this.audioFormat.channels);
        this.sampleData = new float[this.audioFormat.channels][nFrames];
        float[] interleaved = new float[this.audioFormat.channels * nFrames];
        AudioUtils.byteToFloat(interleaved, data, this.audioFormat.bigEndian);
        AudioUtils.deinterleave(interleaved, this.audioFormat.channels, nFrames, this.sampleData);
    }

    private int read(byte[] buffer) {
        if (this.finished) {
            return -1;
        }
        int actualBytesRead = -1;
        try {
            int totalBytesRead;
            for (totalBytesRead = 0; totalBytesRead < buffer.length; totalBytesRead += actualBytesRead) {
                actualBytesRead = this.decodedStream.read(buffer, totalBytesRead, buffer.length - totalBytesRead);
                if (actualBytesRead != -1) continue;
                this.finished = true;
                if (totalBytesRead <= 0) break;
                actualBytesRead = totalBytesRead;
                break;
            }
            if (totalBytesRead == buffer.length) {
                actualBytesRead = totalBytesRead;
            }
        }
        catch (IOException e) {
            this.finished = true;
        }
        if (this.finished || actualBytesRead == -1) {
            this.finished = true;
            return actualBytesRead;
        }
        return actualBytesRead;
    }

    private AudioInputStream getStream() throws UnsupportedAudioFileException, IOException {
        if (this.file != null) {
            return AudioSystem.getAudioInputStream(this.file);
        }
        if (this.url != null) {
            return AudioSystem.getAudioInputStream(this.url);
        }
        return this.audioInputStream;
    }

    private void close() throws IOException {
        if (this.isEncoded) {
            this.decodedStream.close();
        }
        if (this.encodedStream != null) {
            this.encodedStream.close();
            this.encodedStream = null;
        }
        this.decodedStream = null;
    }

    @Override
    public SampleAudioFormat getSampleAudioFormat() {
        return this.audioFormat;
    }
}

