/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data.buffers;

import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.BufferFactory;

public class HanningWindow
extends BufferFactory {
    @Override
    public Buffer generateBuffer(int bufferSize) {
        Buffer b = new Buffer(bufferSize);
        int lowerThresh = bufferSize / 4;
        int upperThresh = bufferSize - lowerThresh;
        for (int i = 0; i < bufferSize; ++i) {
            b.buf[i] = i < lowerThresh || i > upperThresh ? 0.5f * (1.0f + (float)Math.cos(Math.PI + Math.PI * 4 * (double)i / (double)(bufferSize - 1))) : 1.0f;
        }
        return b;
    }

    @Override
    public String getName() {
        return "Hanning";
    }
}

