/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.data.buffers;

import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.BufferFactory;

public class TriangularWindow
extends BufferFactory {
    @Override
    public Buffer generateBuffer(int bufferSize) {
        Buffer b = new Buffer(bufferSize);
        for (int i = 0; i < bufferSize; ++i) {
            b.buf[i] = this.tri(((float)i + 0.5f) / (float)bufferSize) / (float)bufferSize;
        }
        return b;
    }

    protected float tri(float x) {
        if ((double)x < 0.5) {
            return 4.0f * x;
        }
        return 4.0f * (1.0f - x);
    }

    @Override
    public String getName() {
        return "TriangularBuffer";
    }
}

