/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import net.beadsproject.beads.gui.BeadsKeys;
import net.beadsproject.beads.play.InterfaceElement;

public class BeadsPanel
extends JPanel
implements InterfaceElement {
    private static final long serialVersionUID = 1L;
    private int spacing = 1;

    public BeadsPanel() {
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setFont(new Font("Courier", 0, 10));
    }

    @Override
    public Component add(Component c) {
        this.defocusAndAddKeys(c);
        return super.add(c);
    }

    private void defocusAndAddKeys(Component c) {
        if (!(c instanceof JComboBox)) {
            c.setFocusable(false);
            c.addKeyListener(BeadsKeys.singleton);
            if (c instanceof Container) {
                Container cont = (Container)c;
                for (Component next : cont.getComponents()) {
                    this.defocusAndAddKeys(next);
                }
            }
        }
    }

    public void horizontalBox() {
        this.setLayout(new BoxLayout(this, 0));
    }

    public void verticalBox() {
        this.setLayout(new BoxLayout(this, 1));
    }

    public void lineBorder() {
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
    }

    public void coloredLineBorder(Color c, int thickness) {
        if (c == null) {
            c = Color.white;
        }
        this.setBorder(BorderFactory.createLineBorder(c, thickness));
    }

    public void emptyBorder() {
        this.setBorder(BorderFactory.createEmptyBorder(this.spacing, this.spacing, this.spacing, this.spacing));
    }

    public void lineEmptyBorder() {
        Border line = BorderFactory.createLineBorder(Color.black, 1);
        Border empty = BorderFactory.createEmptyBorder(this.spacing, this.spacing, this.spacing, this.spacing);
        CompoundBorder compound = BorderFactory.createCompoundBorder(line, empty);
        this.setBorder(compound);
    }

    public void titledBorder(String title) {
        Border empty = BorderFactory.createEmptyBorder(this.spacing, this.spacing, this.spacing, this.spacing);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(empty, title, 1, 0, new Font("Courier", 1, 11));
        this.setBorder(titleBorder);
    }

    public void highlight() {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), this.getBorder()));
    }

    public void addSpace() {
        Component space = Box.createRigidArea(new Dimension(this.spacing, this.spacing));
        space.setBackground(Color.white);
        this.add(space);
    }

    public void addVerticalSeparator() {
        this.addSpace();
        this.add(new JSeparator(1));
        this.addSpace();
    }

    public void addHorizontalSeparator() {
        this.addSpace();
        this.add(new JSeparator(0));
        this.addSpace();
    }

    public void fixSize(int i, int j) {
        this.fixSize(new Dimension(i, j));
    }

    public void fixSize(Dimension d) {
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
    }

    @Override
    public Dimension getSize() {
        return this.getPreferredSize();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

