/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import net.beadsproject.beads.play.InterfaceElement;

public class ButtonBox
implements InterfaceElement {
    private static Color transparentOverlay = new Color(0.2f, 0.2f, 0.2f, 0.3f);
    private float boxWidth;
    private float boxHeight;
    private int columnHighlight;
    private int rowHighlight;
    protected boolean[][] buttons;
    private ButtonBoxListener listener;
    private int previousX = -1;
    private int previousY = -1;
    private SelectionMode selectionMode;
    private JComponent component;

    public ButtonBox(int width, int height) {
        this(width, height, SelectionMode.SINGLE_SELECTION);
    }

    public ButtonBox(int width, int height, SelectionMode selectionMode) {
        this.resize(width, height);
        this.boxWidth = 10.0f;
        this.boxHeight = 10.0f;
        this.columnHighlight = -1;
        this.rowHighlight = -1;
        this.selectionMode = selectionMode;
    }

    public void resize(int width, int height) {
        boolean[][] oldButtons = this.buttons;
        this.buttons = new boolean[width][height];
        if (oldButtons != null) {
            int minWidth = Math.min(oldButtons.length, this.buttons.length);
            int minHeight = Math.min(oldButtons[0].length, this.buttons[0].length);
            for (int i = 0; i < minWidth; ++i) {
                for (int j = 0; j < minHeight; ++j) {
                    this.buttons[i][j] = oldButtons[i][j];
                }
            }
        }
    }

    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getColumnHighlight() {
        return this.columnHighlight;
    }

    public void setColumnHighlight(int columnHighlight) {
        this.columnHighlight = columnHighlight;
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public void clearColumnHighlight() {
        this.setColumnHighlight(-1);
    }

    public int getRowHighlight() {
        return this.rowHighlight;
    }

    public void setRowHighlight(int rowHighlight) {
        this.rowHighlight = rowHighlight;
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public void clearRowHighlight() {
        this.setRowHighlight(-1);
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new JComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    for (int i = 0; i < ButtonBox.this.buttons.length; ++i) {
                        for (int j = 0; j < ButtonBox.this.buttons[i].length; ++j) {
                            if (ButtonBox.this.buttons[i][j]) {
                                g.setColor(Color.black);
                                g.fillRect((int)((float)i * ButtonBox.this.boxWidth), (int)((float)j * ButtonBox.this.boxHeight), (int)ButtonBox.this.boxWidth, (int)ButtonBox.this.boxHeight);
                                continue;
                            }
                            g.setColor(Color.gray);
                            g.drawRect((int)((float)i * ButtonBox.this.boxWidth), (int)((float)j * ButtonBox.this.boxHeight), (int)ButtonBox.this.boxWidth, (int)ButtonBox.this.boxHeight);
                        }
                    }
                    g.setColor(Color.gray);
                    g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
                    g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
                    if (ButtonBox.this.columnHighlight >= 0) {
                        g.setColor(transparentOverlay);
                        g.fillRect((int)((float)ButtonBox.this.columnHighlight * ButtonBox.this.boxWidth), 0, (int)ButtonBox.this.boxWidth, this.getHeight());
                    }
                    if (ButtonBox.this.rowHighlight >= 0) {
                        g.setColor(transparentOverlay);
                        g.fillRect(0, (int)((float)ButtonBox.this.rowHighlight * ButtonBox.this.boxHeight), this.getWidth(), (int)ButtonBox.this.boxHeight);
                    }
                }
            };
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int i = (int)((float)e.getX() / ButtonBox.this.boxWidth);
                    int j = (int)((float)e.getY() / ButtonBox.this.boxHeight);
                    if (i >= 0 && i < ButtonBox.this.buttons.length && j >= 0 && j < ButtonBox.this.buttons[0].length) {
                        ButtonBox.this.makeSelection(i, j);
                        ButtonBox.this.component.repaint();
                    }
                }
            });
            this.component.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    int i = (int)((float)e.getX() / ButtonBox.this.boxWidth);
                    int j = (int)((float)e.getY() / ButtonBox.this.boxHeight);
                    if (i >= 0 && i < ButtonBox.this.buttons.length && j >= 0 && j < ButtonBox.this.buttons[0].length && (i != ButtonBox.this.previousX || j != ButtonBox.this.previousY)) {
                        ButtonBox.this.makeSelection(i, j);
                        ButtonBox.this.component.repaint();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            Dimension size = new Dimension((int)((float)this.buttons.length * this.boxWidth + 1.0f), (int)((float)this.buttons[0].length * this.boxHeight + 1.0f));
            this.component.setMinimumSize(size);
            this.component.setPreferredSize(size);
            this.component.setMaximumSize(size);
        }
        return this.component;
    }

    public void makeSelection(int i, int j) {
        switch (this.selectionMode) {
            case SINGLE_SELECTION: {
                boolean currentValue = this.buttons[i][j];
                if (this.previousX != -1) {
                    this.buttons[this.previousX][this.previousY] = false;
                }
                boolean bl = this.buttons[i][j] = !currentValue;
                if (this.listener != null) {
                    if (this.buttons[i][j]) {
                        if (this.previousX != i && this.previousY != j && this.previousX != -1) {
                            this.listener.buttonOff(this.previousX, this.previousY);
                        }
                        this.listener.buttonOn(i, j);
                    } else {
                        this.listener.buttonOff(i, j);
                    }
                }
                if (!this.buttons[i][j]) {
                    this.previousX = -1;
                    this.previousY = -1;
                    break;
                }
                this.previousX = i;
                this.previousY = j;
                break;
            }
            case MULTIPLE_SELECTION: {
                boolean bl = this.buttons[i][j] = !this.buttons[i][j];
                if (this.listener != null) {
                    if (this.buttons[i][j]) {
                        this.listener.buttonOn(i, j);
                    } else {
                        this.listener.buttonOff(i, j);
                    }
                }
                this.previousX = i;
                this.previousY = j;
            }
        }
    }

    public void clear() {
        int width = this.buttons.length;
        int height = this.buttons[0].length;
        this.buttons = new boolean[width][height];
    }

    public float getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(float boxWidth) {
        this.boxWidth = boxWidth;
    }

    public float getBoxHeight() {
        return this.boxHeight;
    }

    public void setBoxHeight(float boxHeight) {
        this.boxHeight = boxHeight;
    }

    public ButtonBoxListener getListener() {
        return this.listener;
    }

    public void setListener(ButtonBoxListener listener) {
        this.listener = listener;
    }

    public boolean[][] getButtons() {
        return this.buttons;
    }

    public int getWidth() {
        return this.buttons.length;
    }

    public int getHeight() {
        return this.buttons[0].length;
    }

    public static interface ButtonBoxListener {
        public void buttonOn(int var1, int var2);

        public void buttonOff(int var1, int var2);
    }

    public static enum SelectionMode {
        SINGLE_SELECTION,
        MULTIPLE_SELECTION;

    }
}

