/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.gui.BeadsComponent;
import net.beadsproject.beads.play.InterfaceElement;

public class LevelMeter
implements InterfaceElement {
    private UGen focus;
    private JComponent component;
    private int currentLevel;
    private int numLevels;
    private int range;
    private int outputIndex;

    public LevelMeter(UGen focus) {
        this(focus, 0);
    }

    public LevelMeter(UGen focus, int outputIndex) {
        this.setFocus(focus, outputIndex);
        this.setNumLevels(10);
        this.range = 50;
        this.currentLevel = 0;
    }

    public UGen getFocus() {
        return this.focus;
    }

    public void setFocus(UGen focus) {
        this.setFocus(focus, 0);
    }

    public void setFocus(UGen focus, int outputIndex) {
        this.focus = focus;
        this.outputIndex = outputIndex;
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public void setNumLevels(int numLevels) {
        this.numLevels = Math.max(0, numLevels);
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new BeadsComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    int levelBoxHeight = this.getHeight() / LevelMeter.this.numLevels;
                    LevelMeter.this.getCurrentLevel();
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    for (int i = 0; i < LevelMeter.this.currentLevel; ++i) {
                        if (i < LevelMeter.this.numLevels / 2) {
                            g.setColor(Color.green);
                        } else if ((float)i < (float)(3 * LevelMeter.this.numLevels) / 4.0f) {
                            g.setColor(Color.orange);
                        } else {
                            g.setColor(Color.red);
                        }
                        g.fillRect(1, this.getHeight() - (i + 1) * levelBoxHeight, this.getWidth() - 2, levelBoxHeight - 1);
                    }
                }
            };
            Dimension size = new Dimension(10, 100);
            this.component.setMinimumSize(size);
            this.component.setPreferredSize(size);
            this.component.setMaximumSize(size);
            new Thread(){

                @Override
                public void run() {
                    while (this.isAlive()) {
                        LevelMeter.this.component.repaint();
                        try {
                            2.sleep(100L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
        }
        return this.component;
    }

    private void getCurrentLevel() {
        if (this.focus != null && !this.focus.isPaused() && !this.focus.isDeleted()) {
            float max = 0.0f;
            this.range = Math.min(this.range, this.focus.getContext().getBufferSize());
            for (int i = 0; i < this.range; ++i) {
                float val = Math.abs(this.focus.getValue(this.outputIndex, i));
                if (!(val > max)) continue;
                max = val;
            }
            this.currentLevel = (int)(max * (float)this.numLevels);
        } else {
            this.currentLevel = 0;
        }
    }
}

