/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import net.beadsproject.beads.analysis.SegmentListener;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.TimeStamp;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.gui.BeadsComponent;
import net.beadsproject.beads.play.InterfaceElement;

public class OnsetView
extends UGen
implements InterfaceElement,
SegmentListener {
    int framesSinceOnset = 20;
    JComponent component = null;

    public OnsetView(AudioContext context) {
        super(context);
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            class OnsetViewComponent
            extends BeadsComponent {
                private static final long serialVersionUID = 1L;

                OnsetViewComponent() {
                }

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    if (OnsetView.this.framesSinceOnset <= 15) {
                        float intensity = Math.max(0.0f, 1.0f - (float)Math.pow((float)OnsetView.this.framesSinceOnset / 15.0f, 2.0));
                        g.setColor(new Color(0.2f, 0.2f, 0.2f, intensity));
                        g.fillRect(20, 20, this.getWidth() - 40, this.getHeight() - 40);
                    }
                }
            }
            this.component = new OnsetViewComponent();
            Dimension size = new Dimension(100, 100);
            this.component.setMinimumSize(size);
            this.component.setPreferredSize(size);
            this.component.setMaximumSize(size);
        }
        return this.component;
    }

    @Override
    public void newSegment(TimeStamp start, TimeStamp end) {
        this.framesSinceOnset = 0;
    }

    @Override
    public void calculateBuffer() {
        ++this.framesSinceOnset;
        if (this.component != null && this.framesSinceOnset % 3 == 0) {
            this.component.repaint();
        }
    }
}

