/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.JComponent;
import net.beadsproject.beads.gui.BeadsComponent;
import net.beadsproject.beads.gui.BeadsWindow;
import net.beadsproject.beads.play.InterfaceElement;

public class Range
implements InterfaceElement {
    private static Color transparentOverlay = new Color(0.2f, 0.2f, 0.2f, 0.3f);
    private JComponent component;
    private String name;
    private float min;
    private float max;
    private float rangeMin;
    private float rangeMax;
    private boolean dragMax;
    NumberFormat nf;

    public Range(String name, float min, float max, float rangeMin, float rangeMax) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.dragMax = false;
        this.checkRange();
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(6);
    }

    private void checkRange() {
        if (this.rangeMin > this.rangeMax) {
            this.dragMax = !this.dragMax;
            float temp = this.rangeMin;
            this.rangeMin = this.rangeMax;
            this.rangeMax = temp;
        }
        if (this.rangeMin < this.min) {
            this.rangeMin = this.min;
        }
        if (this.rangeMax > this.max) {
            this.rangeMax = this.max;
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new BeadsComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.gray);
                    g2d.rotate(-1.5707963267948966);
                    g.drawString(Range.this.name, -this.getHeight() + 2, 12);
                    g.drawString(Range.this.nf.format(Range.this.rangeMin), -this.getHeight() + 2, 26);
                    g.drawString(Range.this.nf.format(Range.this.rangeMax), -this.getHeight() + 2 + this.getHeight() / 3, 26);
                    g2d.rotate(1.5707963267948966);
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    int minHeight = Range.this.valueToPixel(Range.this.rangeMin);
                    int maxHeight = Range.this.valueToPixel(Range.this.rangeMax);
                    g.setColor(transparentOverlay);
                    g.fillRect(0, maxHeight, this.getWidth(), minHeight - maxHeight);
                    g.setColor(Color.black);
                    g.drawLine(0, minHeight, this.getWidth(), minHeight);
                    g.drawLine(0, maxHeight, this.getWidth(), maxHeight);
                }
            };
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    float mouseVal = Range.this.pixelToValue(e.getY());
                    if (Math.abs(mouseVal - Range.this.rangeMax) < Math.abs(mouseVal - Range.this.rangeMin)) {
                        Range.this.dragMax = true;
                        Range.this.rangeMax = mouseVal;
                    } else {
                        Range.this.dragMax = false;
                        Range.this.rangeMin = mouseVal;
                    }
                    Range.this.checkRange();
                    Range.this.component.repaint();
                }
            });
            this.component.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (Range.this.dragMax) {
                        Range.this.rangeMax = Range.this.pixelToValue(e.getY());
                    } else {
                        Range.this.rangeMin = Range.this.pixelToValue(e.getY());
                    }
                    Range.this.checkRange();
                    Range.this.component.repaint();
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            Dimension size = new Dimension(30, 100);
            this.component.setMinimumSize(size);
            this.component.setPreferredSize(size);
            this.component.setMaximumSize(size);
        }
        return this.component;
    }

    private int valueToPixel(float value) {
        if (this.component == null) {
            return 0;
        }
        return (int)((1.0f - (value - this.min) / (this.max - this.min)) * (float)this.component.getHeight());
    }

    private float pixelToValue(int pixel) {
        if (this.component == null) {
            return 0.0f;
        }
        return (1.0f - (float)pixel / (float)this.component.getHeight()) * (this.max - this.min) + this.min;
    }

    public float getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(float rangeMin) {
        this.rangeMin = rangeMin;
        this.checkRange();
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public float getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(float rangeMax) {
        this.rangeMax = rangeMax;
        this.checkRange();
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public float randomInRange(Random rng) {
        return rng.nextFloat() * (this.rangeMax - this.rangeMin) + this.rangeMin;
    }

    public static void main(String[] args) {
        BeadsWindow w = new BeadsWindow("test");
        Range r = new Range("Sample length", 0.0f, 1.0f, 0.1f, 0.2f);
        w.content.add(r.getComponent());
        w.pack();
        w.setVisible(true);
    }
}

