/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.beadsproject.beads.gui.BeadsPanel;
import net.beadsproject.beads.play.InterfaceElement;

public class Readout
implements InterfaceElement {
    private JLabel label = new JLabel();
    private String text;
    private JComponent component;
    private int boxHeight = 10;
    private int boxWidth = 100;
    private int textVOffset = 1;

    public Readout() {
        this.label.setFont(new Font("Courier", 0, 10));
    }

    public Readout(String label, String text) {
        this();
        this.setLabel(label);
        this.setText(text);
    }

    public void setText(String text) {
        this.text = text;
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public void setLabel(String label) {
        String tempLabel = label;
        while (tempLabel.length() < 7) {
            tempLabel = tempLabel + " ";
        }
        this.label.setText(tempLabel);
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public String getText() {
        return this.text;
    }

    public String getLabel() {
        return this.label.getText();
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            JComponent subComponent = new JComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (Readout.this.text != null) {
                        g.setColor(Color.black);
                        g.drawString(Readout.this.text, 0, Readout.this.boxHeight - Readout.this.textVOffset);
                    }
                }
            };
            Dimension size = new Dimension(this.boxWidth, this.boxHeight);
            BeadsPanel bp = new BeadsPanel();
            bp.horizontalBox();
            bp.add(this.label);
            bp.add(subComponent);
            this.component = bp;
            this.component.setMinimumSize(size);
            this.component.setPreferredSize(size);
            this.component.setMaximumSize(size);
        }
        return this.component;
    }
}

