/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import net.beadsproject.beads.data.SampleManager;
import net.beadsproject.beads.gui.BeadsWindow;
import net.beadsproject.beads.play.InterfaceElement;

public class SampleManagerPanel
implements InterfaceElement {
    private static final String newText = "New...";
    private int textVOffset = 2;
    private JComponent component;
    private int boxHeight = 10;
    private String hoveredBox = null;
    private ArrayList<String> chosenBoxes = new ArrayList();
    private File rootDirectoryForAudio;
    private int maxSamples;

    public SampleManagerPanel() {
        this(null);
    }

    public SampleManagerPanel(String s) {
        this(s, Integer.MAX_VALUE);
    }

    public SampleManagerPanel(int x) {
        this(null, x);
    }

    public SampleManagerPanel(String s, int maxSamples) {
        this.maxSamples = maxSamples;
        if (s != null) {
            this.rootDirectoryForAudio = new File(s);
        }
    }

    public void setMaxSamples(int x) {
        this.maxSamples = x;
    }

    public void setRootDir(String s) {
        this.rootDirectoryForAudio = s == null ? null : new File(s);
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new JComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (SampleManagerPanel.this.hoveredBox == SampleManagerPanel.newText) {
                        g.setColor(Color.lightGray);
                        g.fillRect(0, 0, this.getWidth(), SampleManagerPanel.this.boxHeight);
                    }
                    g.setColor(Color.black);
                    g.drawString(SampleManagerPanel.newText, 2, SampleManagerPanel.this.boxHeight - SampleManagerPanel.this.textVOffset);
                    int i = 1;
                    for (String s : SampleManager.groups()) {
                        if (SampleManagerPanel.this.chosenBoxes.contains(s)) {
                            g.setColor(Color.darkGray);
                            g.fillRect(0, i * SampleManagerPanel.this.boxHeight, this.getWidth(), SampleManagerPanel.this.boxHeight);
                            g.setColor(Color.white);
                            g.drawString(s, 2, (i + 1) * SampleManagerPanel.this.boxHeight - SampleManagerPanel.this.textVOffset);
                        } else if (SampleManagerPanel.this.hoveredBox == s) {
                            g.setColor(Color.lightGray);
                            g.fillRect(0, i * SampleManagerPanel.this.boxHeight, this.getWidth(), SampleManagerPanel.this.boxHeight);
                            g.setColor(Color.black);
                            g.drawString(s, 2, (i + 1) * SampleManagerPanel.this.boxHeight - SampleManagerPanel.this.textVOffset);
                        } else {
                            g.setColor(Color.black);
                            g.drawString(s, 2, (i + 1) * SampleManagerPanel.this.boxHeight - SampleManagerPanel.this.textVOffset);
                        }
                        ++i;
                    }
                }
            };
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    List<String> groupList = SampleManager.groupsAsList();
                    int index = e.getY() / SampleManagerPanel.this.boxHeight;
                    if (index == 0) {
                        final JFileChooser chooser = new JFileChooser(SampleManagerPanel.this.rootDirectoryForAudio);
                        chooser.setMultiSelectionEnabled(true);
                        chooser.setFileSelectionMode(2);
                        int returnVal = chooser.showOpenDialog(SampleManagerPanel.this.component);
                        if (returnVal == 0) {
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    File[] files;
                                    for (File f : files = chooser.getSelectedFiles()) {
                                        SampleManager.group(f.getName(), f.getAbsolutePath(), SampleManagerPanel.this.maxSamples);
                                    }
                                    SampleManagerPanel.this.component.repaint();
                                }
                            });
                            t.setPriority(1);
                            t.start();
                        }
                    } else if (--index < groupList.size()) {
                        String s = groupList.get(index);
                        if ((e.getModifiers() & 1) == 0) {
                            if (!SampleManagerPanel.this.chosenBoxes.contains(s)) {
                                SampleManagerPanel.this.chosenBoxes.clear();
                                SampleManagerPanel.this.chosenBoxes.add(s);
                            } else {
                                SampleManagerPanel.this.chosenBoxes.clear();
                            }
                        } else if (!SampleManagerPanel.this.component.hasFocus()) {
                            if (SampleManagerPanel.this.chosenBoxes.contains(s)) {
                                SampleManagerPanel.this.chosenBoxes.remove(s);
                            } else {
                                SampleManagerPanel.this.chosenBoxes.add(s);
                            }
                        }
                    }
                    SampleManagerPanel.this.component.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SampleManagerPanel.this.hoveredBox = null;
                }
            });
            this.component.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    List<String> groupList = SampleManager.groupsAsList();
                    int index = e.getY() / SampleManagerPanel.this.boxHeight;
                    if (index == 0) {
                        SampleManagerPanel.this.hoveredBox = SampleManagerPanel.newText;
                    } else if (--index < groupList.size()) {
                        SampleManagerPanel.this.hoveredBox = groupList.get(index);
                    }
                    SampleManagerPanel.this.component.repaint();
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent k) {
                    if (k.getKeyCode() == 8) {
                        for (String s : SampleManagerPanel.this.chosenBoxes) {
                            SampleManager.destroyGroup(s);
                        }
                        SampleManagerPanel.this.component.repaint();
                    }
                }
            });
            Dimension d = new Dimension(100, 500);
            this.component.setMinimumSize(d);
            this.component.setPreferredSize(d);
            this.component.setMaximumSize(d);
        }
        return this.component;
    }

    public static void main(String[] args) {
        BeadsWindow b = new BeadsWindow("test sample window");
        b.content.add(new SampleManagerPanel().getComponent());
        SampleManager.group("audio", "audio");
        SampleManager.group("other", "/Users/ollie/Music/Audio/classic breaks");
        b.pack();
        b.setVisible(true);
    }
}

