/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import net.beadsproject.beads.data.Sample;
import net.beadsproject.beads.gui.BeadsComponent;
import net.beadsproject.beads.play.InterfaceElement;
import net.beadsproject.beads.ugens.SamplePlayer;

public class SampleView
implements InterfaceElement {
    private static Color transparentOverlay = new Color(0.2f, 0.2f, 0.2f, 0.3f);
    private static Color veryTransparentOverlay = new Color(0.2f, 0.2f, 0.2f, 0.1f);
    private static Stroke lightStroke = new BasicStroke(0.1f);
    private Sample sample;
    private int[] view;
    private int selectionStart;
    private int selectionEnd;
    private int tempSelectionMarker;
    private int height;
    private int width;
    private int chunkSize;
    private JComponent component;
    private SelectMode selectionMode;
    private SnapMode snapMode;
    private SampleViewListener listener;
    private TreeSet<Double> snapPoints;
    private double[] orderedSnapPoints;
    private SamplePlayer player;
    private BufferedImage waveForm;

    public SampleView() {
        this(null);
    }

    public SampleView(Sample sample) {
        this.sample = sample;
        this.height = 100;
        this.chunkSize = 200;
        this.setWidth(500);
        this.selectionMode = SelectMode.REGION;
        this.snapMode = SnapMode.FREE;
        this.snapPoints = new TreeSet();
        this.orderedSnapPoints = null;
        this.player = null;
    }

    public void bindToSamplePlayer(SamplePlayer sp) {
        this.player = sp;
    }

    public int getSelectionStartPixels() {
        return this.selectionStart;
    }

    public void setSelectionStartPixels(int selectionStart) {
        this.selectionStart = selectionStart;
    }

    public int getSelectionEndPixels() {
        return this.selectionEnd;
    }

    public void setSelectionEndPixels(int selectionEnd) {
        this.selectionEnd = selectionEnd;
    }

    public double getSelectionStartMS() {
        return this.pixelsToMS(this.selectionStart);
    }

    public void setSelectionStartMS(double selectionStart) {
        this.selectionStart = this.msToPixels(selectionStart);
    }

    public double getSelectionEndMS() {
        return this.pixelsToMS(this.selectionEnd);
    }

    public void setSelectionEndMS(double selectionEnd) {
        this.selectionEnd = this.msToPixels(selectionEnd);
    }

    public SelectMode getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(SelectMode mode) {
        this.selectionMode = mode;
    }

    public SnapMode getSnapMode() {
        return this.snapMode;
    }

    public void setSnapMode(SnapMode snapMode) {
        this.snapMode = snapMode;
    }

    public void addSnapPoint(double timeMS) {
        this.snapPoints.add(timeMS);
        this.orderedSnapPoints = null;
        this.waveForm = null;
    }

    public void clearSnapPoints() {
        this.snapPoints.clear();
    }

    public Set<Double> getSnapPoints() {
        return this.snapPoints;
    }

    public double getSnapPointBefore(double d) {
        return this.snapPoints.headSet(d).last();
    }

    public double getSnapPointAfter(double d) {
        SortedSet<Double> tailSet = this.snapPoints.tailSet(d);
        if (tailSet == null || tailSet.size() == 0) {
            return this.sample.getLength();
        }
        return tailSet.first();
    }

    public double getNearestSnapPoint(double d) {
        double before = this.getSnapPointBefore(d);
        double after = this.getSnapPointAfter(d);
        if (Math.abs(before - d) > Math.abs(after - d)) {
            return after;
        }
        return before;
    }

    public void setSample(Sample sample) {
        this.sample = sample;
        this.clearSnapPoints();
        this.calculateOverview();
    }

    public synchronized void redraw() {
        if (this.component != null) {
            this.calculateOverview();
            this.component.repaint();
        }
    }

    public Sample getSample() {
        return this.sample;
    }

    public void setWidth(int width) {
        this.width = width;
        this.view = new int[width];
        this.calculateOverview();
    }

    public SampleViewListener getListener() {
        return this.listener;
    }

    public void setListener(SampleViewListener listener) {
        this.listener = listener;
    }

    private void calculateOverview() {
        if (this.sample != null) {
            float[] frame = new float[this.sample.getNumChannels()];
            if (this.sample != null) {
                double hop = (double)this.sample.getNumFrames() / (double)this.width;
                for (int i = 0; i < this.width; ++i) {
                    int index = (int)((double)i * hop);
                    float average = 0.0f;
                    int maxJ = Math.min(this.chunkSize, (int)this.sample.getNumFrames() - index);
                    for (int j = 0; j < maxJ; ++j) {
                        this.sample.getFrame(index + j, frame);
                        average += Math.abs(frame[0]);
                    }
                    if (maxJ != 0) {
                        average /= (float)maxJ;
                    }
                    this.view[i] = (int)((average + 1.0f) * (float)this.height / 2.0f);
                }
            }
        }
        this.waveForm = null;
    }

    private void recalculateBackgroundImage() {
        int i;
        this.waveForm = new BufferedImage(this.width, this.height, 1);
        Graphics g = this.waveForm.getGraphics();
        ((Graphics2D)g).setStroke(lightStroke);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.black);
        g.drawRect(0, 0, this.width - 1, this.height - 1);
        if (this.view != null) {
            for (i = 1; i < this.view.length; ++i) {
                g.drawLine(i - 1, this.view[i - 1], i, this.view[i]);
                g.drawLine(i - 1, this.height - this.view[i - 1], i, this.height - this.view[i]);
            }
        }
        g.setColor(transparentOverlay);
        if (this.snapPoints != null) {
            if (this.orderedSnapPoints == null) {
                this.orderedSnapPoints = new double[this.snapPoints.size()];
                int count = 0;
                for (Double d : this.snapPoints) {
                    int x = (int)(d * (double)this.width / this.sample.getLength());
                    g.drawLine(x, 0, x, this.height);
                    this.orderedSnapPoints[count++] = d;
                }
            } else {
                for (i = 0; i < this.orderedSnapPoints.length; ++i) {
                    int x = (int)(this.orderedSnapPoints[i] * (double)this.width / this.sample.getLength());
                    g.drawLine(x, 0, x, this.height);
                }
            }
        }
        if (this.component != null) {
            this.component.getTopLevelAncestor().repaint();
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            final BeadsComponent subComponent = new BeadsComponent(){

                @Override
                public void paintComponent(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (SampleView.this.waveForm == null) {
                        SampleView.this.recalculateBackgroundImage();
                    }
                    g.drawImage(SampleView.this.waveForm, 0, 0, null);
                    g.setColor(transparentOverlay);
                    if (SampleView.this.player != null) {
                        int x = (int)(SampleView.this.player.getPosition() / SampleView.this.sample.getLength() * (double)this.getWidth());
                        g.drawLine(x, 0, x, this.getHeight());
                    }
                    g.setColor(veryTransparentOverlay);
                    g.fillRect(Math.min(SampleView.this.selectionStart, SampleView.this.selectionEnd), 0, Math.abs(SampleView.this.selectionEnd - SampleView.this.selectionStart), SampleView.this.height);
                }
            };
            subComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SampleView.this.snapMode == SnapMode.FREE) {
                        SampleView.this.selectionStart = e.getX();
                        SampleView.this.selectionEnd = SampleView.this.selectionStart + 1;
                    } else {
                        SampleView.this.tempSelectionMarker = e.getX();
                        SampleView.this.selectionStart = (int)((double)SampleView.this.width / SampleView.this.sample.getLength() * SampleView.this.getSnapPointBefore((double)((float)e.getX() / (float)SampleView.this.width) * SampleView.this.sample.getLength()));
                        SampleView.this.selectionEnd = (int)((double)SampleView.this.width / SampleView.this.sample.getLength() * SampleView.this.getSnapPointAfter((double)((float)e.getX() / (float)SampleView.this.width) * SampleView.this.sample.getLength()));
                    }
                    if (SampleView.this.listener != null) {
                        SampleView.this.listener.selectionChanged(SampleView.this.pixelsToMS(Math.min(SampleView.this.selectionStart, SampleView.this.selectionEnd)), SampleView.this.pixelsToMS(Math.max(SampleView.this.selectionStart, SampleView.this.selectionEnd)));
                    }
                    subComponent.repaint();
                }
            });
            subComponent.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (e.getX() > 0 && e.getX() < SampleView.this.width && e.getY() > 0 && e.getY() < SampleView.this.height) {
                        switch (SampleView.this.selectionMode) {
                            case REGION: {
                                if (SampleView.this.snapMode == SnapMode.FREE) {
                                    SampleView.this.selectionStart = e.getX();
                                    break;
                                }
                                int min = Math.min(SampleView.this.tempSelectionMarker, e.getX());
                                int max = Math.max(SampleView.this.tempSelectionMarker, e.getX());
                                SampleView.this.selectionStart = (int)((double)SampleView.this.width / SampleView.this.sample.getLength() * SampleView.this.getSnapPointBefore((double)((float)min / (float)SampleView.this.width) * SampleView.this.sample.getLength()));
                                SampleView.this.selectionEnd = (int)((double)SampleView.this.width / SampleView.this.sample.getLength() * SampleView.this.getSnapPointAfter((double)((float)max / (float)SampleView.this.width) * SampleView.this.sample.getLength()));
                                break;
                            }
                            case POSITION: {
                                if (SampleView.this.snapMode == SnapMode.FREE) {
                                    SampleView.this.selectionStart = e.getX();
                                } else {
                                    SampleView.this.selectionStart = (int)((double)SampleView.this.width / SampleView.this.sample.getLength() * SampleView.this.getSnapPointBefore((double)((float)e.getX() / (float)SampleView.this.width) * SampleView.this.sample.getLength()));
                                }
                                SampleView.this.selectionEnd = SampleView.this.selectionStart + 1;
                            }
                        }
                        if (SampleView.this.listener != null) {
                            SampleView.this.listener.selectionChanged(SampleView.this.pixelsToMS(Math.min(SampleView.this.selectionStart, SampleView.this.selectionEnd)), SampleView.this.pixelsToMS(Math.max(SampleView.this.selectionStart, SampleView.this.selectionEnd)));
                        }
                        subComponent.repaint();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            this.component = subComponent;
            Dimension size = new Dimension(this.width, this.height);
            subComponent.setMinimumSize(size);
            subComponent.setPreferredSize(size);
            subComponent.setMaximumSize(size);
        }
        return this.component;
    }

    public double pixelsToMS(int pixels) {
        return (double)pixels / (double)this.width * this.sample.getLength();
    }

    public int msToPixels(double ms) {
        return (int)(ms * (double)this.width / this.sample.getLength());
    }

    public static interface SampleViewListener {
        public void selectionChanged(double var1, double var3);
    }

    public static enum SnapMode {
        GRID,
        FREE;

    }

    public static enum SelectMode {
        REGION,
        POSITION;

    }
}

