/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.beadsproject.beads.gui.BeadsWindow;
import net.beadsproject.beads.play.InterfaceElement;

public class SingleButton
implements InterfaceElement {
    private JComponent component;
    private int boxWidth;
    private int textWidth;
    private int textVOffset;
    private Mode mode;
    private boolean state;
    private String label;
    private Font font;
    SingleButtonListener listener;

    public SingleButton(String name) {
        this(name, Mode.TOGGLE);
    }

    public SingleButton(String name, Mode mode) {
        this.label = name;
        this.listener = null;
        this.mode = mode;
        this.boxWidth = 10;
        this.textWidth = 100;
        this.textVOffset = 1;
        this.font = new Font("Courier", 0, 10);
        this.state = false;
    }

    public boolean state() {
        return this.state;
    }

    public void setState(boolean state) {
        if (this.mode == Mode.TOGGLE) {
            this.state = state;
            if (this.component != null) {
                this.component.repaint();
            }
        }
        if (this.listener != null) {
            this.listener.buttonPressed(state);
        }
    }

    @Override
    public JComponent getComponent() {
        this.component = new JComponent(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.black);
                if (SingleButton.this.state) {
                    g.fillRect(0, 0, SingleButton.this.boxWidth, SingleButton.this.boxWidth);
                } else {
                    g.drawRect(0, 0, SingleButton.this.boxWidth, SingleButton.this.boxWidth);
                }
                g.setFont(SingleButton.this.font);
                g.drawString(SingleButton.this.label, SingleButton.this.boxWidth + 4, SingleButton.this.boxWidth - SingleButton.this.textVOffset);
            }
        };
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                switch (SingleButton.this.mode) {
                    case TOGGLE: {
                        SingleButton.this.state = !SingleButton.this.state;
                        break;
                    }
                    case ONESHOT: {
                        break;
                    }
                    case HOLD: {
                        SingleButton.this.state = true;
                    }
                }
                if (SingleButton.this.listener != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SingleButton.this.listener.buttonPressed(SingleButton.this.state);
                        }
                    });
                }
                SingleButton.this.component.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SingleButton.this.mode == Mode.ONESHOT && SingleButton.this.state) {
                    SingleButton.this.state = false;
                    SingleButton.this.component.repaint();
                } else if (SingleButton.this.mode == Mode.HOLD && SingleButton.this.state) {
                    SingleButton.this.state = false;
                    SingleButton.this.component.repaint();
                    if (SingleButton.this.listener != null) {
                        SingleButton.this.listener.buttonPressed(SingleButton.this.state);
                    }
                }
            }
        });
        Dimension size = new Dimension(this.boxWidth + 1 + this.textWidth, this.boxWidth + 1);
        this.component.setMinimumSize(size);
        this.component.setPreferredSize(size);
        this.component.setMaximumSize(size);
        return this.component;
    }

    public void setListener(SingleButtonListener l) {
        this.listener = l;
    }

    public static void main(String[] args) {
        BeadsWindow f = new BeadsWindow("buttons");
        SingleButton b1 = new SingleButton("button 1", Mode.TOGGLE);
        b1.setListener(new SingleButtonListener(){

            @Override
            public void buttonPressed(boolean newState) {
                System.out.println("B1 pressed, state = " + newState);
            }
        });
        f.add(b1.getComponent());
        SingleButton b2 = new SingleButton("button 2", Mode.ONESHOT);
        b2.setListener(new SingleButtonListener(){

            @Override
            public void buttonPressed(boolean newState) {
                System.out.println("B2 pressed, state = " + newState);
            }
        });
        f.add(b2.getComponent());
        SingleButton b3 = new SingleButton("button 2", Mode.HOLD);
        b3.setListener(new SingleButtonListener(){

            @Override
            public void buttonPressed(boolean newState) {
                System.out.println("B3 pressed, state = " + newState);
            }
        });
        f.add(b3.getComponent());
        f.pack();
        f.setVisible(true);
    }

    public static interface SingleButtonListener {
        public void buttonPressed(boolean var1);
    }

    public static enum Mode {
        TOGGLE,
        ONESHOT,
        HOLD;

    }
}

