/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.data.Buffer;
import net.beadsproject.beads.data.buffers.Exp01Buffer;
import net.beadsproject.beads.data.buffers.Log01Buffer;
import net.beadsproject.beads.gui.BeadsComponent;
import net.beadsproject.beads.gui.BeadsDialog;
import net.beadsproject.beads.gui.BeadsPanel;
import net.beadsproject.beads.play.InterfaceElement;
import net.beadsproject.beads.ugens.Envelope;

public class Slider
extends Envelope
implements InterfaceElement {
    private float min;
    private float max;
    private float value;
    private JComponent component;
    private Vector<Float> storedValues = new Vector();
    private float smoothnessInterval;
    private String name;
    private Buffer logBuffer;
    private Buffer expBuffer;

    public Slider(AudioContext context, String nam, float min, float max, float val) {
        this(context, nam, min, max, val, false);
    }

    public Slider(AudioContext context, String nam, float min, float max, float val, boolean log) {
        super(context);
        this.name = nam;
        this.setMin(Math.min(min, max));
        this.setMax(Math.max(min, max));
        this.setValue(val);
        this.smoothnessInterval = 20.0f;
        this.useLogBuffer(log);
    }

    public float calculateValueFromFract(float fract) {
        if (this.logBuffer != null) {
            fract = this.expBuffer.getValueFraction(fract);
        }
        return Math.max(this.min, Math.min(this.max, fract * (this.max - this.min) + this.min));
    }

    public void setValueFract(float fract) {
        if (this.logBuffer != null) {
            fract = this.expBuffer.getValueFraction(fract);
        }
        this.setValue(fract * (this.max - this.min) + this.min);
    }

    public float getValueFract() {
        float fract = (this.value - this.min) / (this.max - this.min);
        if (this.logBuffer != null) {
            fract = this.logBuffer.getValueFraction(fract);
        }
        return fract;
    }

    public float calculateFractFromValue(float value) {
        float fract = (value - this.min) / (this.max - this.min);
        if (this.logBuffer != null) {
            fract = this.logBuffer.getValueFraction(fract);
        }
        return fract;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setValue(float val) {
        this.value = Math.max(this.min, Math.min(this.max, val));
        this.clear();
        this.addSegment(this.value, this.smoothnessInterval);
        if (this.component != null) {
            this.component.repaint();
        }
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public float getSmoothnessInterval() {
        return this.smoothnessInterval;
    }

    public void setSmoothnessInterval(float smoothnessInterval) {
        this.smoothnessInterval = smoothnessInterval;
    }

    @Override
    public void calculateBuffer() {
        super.calculateBuffer();
        this.value = this.myBufOut[0];
        if (this.component != null && this.context.getTimeStep() % 4L == 0L) {
            this.component.repaint();
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new BeadsComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    Graphics2D g2d = (Graphics2D)g;
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(Color.gray);
                    g.drawString(Slider.this.name, 2, 12);
                    g.drawString("" + Slider.this.value, 2, 26);
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    float fract = Slider.this.getValueFract();
                    int sliderHeight = (int)((float)this.getHeight() * (1.0f - fract));
                    if (Slider.this.isLocked()) {
                        g.setColor(Color.gray);
                    }
                    g.drawLine(0, sliderHeight, this.getWidth(), sliderHeight);
                }
            };
            this.component.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if ((e.getModifiers() & 2) != 0) {
                        Slider.this.runEnvelopeDrawPanel();
                    } else if ((e.getModifiers() & 8) != 0) {
                        Slider.this.runTextSelectPanel();
                    } else if (!Slider.this.isLocked()) {
                        Slider.this.setValueFract(1.0f - (float)e.getY() / (float)Slider.this.component.getHeight());
                    }
                }
            });
            this.component.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (!Slider.this.isLocked()) {
                        float valueFract = 1.0f - (float)e.getY() / (float)Slider.this.component.getHeight();
                        valueFract = Math.min(Math.max(valueFract, 0.0f), 1.0f);
                        Slider.this.setValueFract(valueFract);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                }
            });
            Dimension size = new Dimension(30, 100);
            this.component.setMinimumSize(size);
            this.component.setPreferredSize(size);
            this.component.setMaximumSize(size);
        }
        return this.component;
    }

    private void runEnvelopeDrawPanel() {
        final int[] x = new int[2];
        x[1] = 0;
        x[0] = 0;
        final int[] y = new int[2];
        y[0] = y[1] = (int)((1.0f - this.getValueFract()) * (float)this.component.getHeight());
        final BeadsPanel drawPanel = new BeadsPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(Color.black);
                g.drawLine(x[0], y[0], x[1], y[1]);
            }
        };
        final BeadsDialog drawWindow = new BeadsDialog((Frame)this.component.getTopLevelAncestor());
        drawWindow.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                x[1] = e.getX();
                y[1] = e.getY();
                drawPanel.repaint();
            }
        });
        drawWindow.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                drawWindow.dispose();
                Slider.this.setValue(Slider.this.calculateValueFromFract(1.0f - (float)y[0] / (float)Slider.this.component.getHeight()));
                Slider.this.addSegment(Slider.this.calculateValueFromFract(1.0f - (float)y[1] / (float)Slider.this.component.getHeight()), (float)x[1] / (float)drawPanel.getWidth() * 10000.0f);
            }
        });
        drawWindow.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                drawWindow.dispose();
            }
        });
        drawWindow.setContentPane(drawPanel);
        drawWindow.setUndecorated(true);
        drawWindow.setSize(new Dimension(this.component.getWidth() + 200, this.component.getHeight()));
        drawWindow.setLocation(new Point(this.component.getLocationOnScreen().x + this.component.getWidth(), this.component.getLocationOnScreen().y));
        drawWindow.setVisible(true);
    }

    public void storeValue(float f) {
        if (!this.storedValues.contains(Float.valueOf(f))) {
            this.storedValues.add(Float.valueOf(f));
        }
    }

    public void runTextSelectPanel() {
        final BeadsDialog drawWindow = new BeadsDialog((Frame)this.component.getTopLevelAncestor());
        BeadsPanel drawPanel = new BeadsPanel();
        final JComboBox<Float> selector = new JComboBox<Float>(this.storedValues);
        selector.setEditable(true);
        selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selection = selector.getSelectedItem();
                try {
                    float f = Float.parseFloat(selection.toString());
                    Slider.this.storeValue(f);
                    Slider.this.setValue(f);
                    drawWindow.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        selector.setSize(new Dimension(100, 0));
        ((Container)drawPanel).add(selector);
        drawPanel.setSize(new Dimension(100, 0));
        drawWindow.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                drawWindow.dispose();
            }
        });
        drawWindow.setContentPane(drawPanel);
        drawWindow.setUndecorated(true);
        drawWindow.pack();
        drawWindow.setLocation(new Point(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y));
        drawWindow.setVisible(true);
    }

    public void useLogBuffer(boolean useLogBuffer) {
        if (useLogBuffer) {
            this.logBuffer = new Log01Buffer().getDefault();
            this.expBuffer = new Exp01Buffer().getDefault();
        } else {
            this.logBuffer = null;
            this.expBuffer = null;
        }
    }
}

