/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.play.InterfaceElement;
import net.beadsproject.beads.ugens.Clock;

public class TimeGraph
extends Bead
implements InterfaceElement {
    private int boxWidth;
    private int range;
    private int currentTime;
    private JComponent component;

    public TimeGraph() {
        this(10);
    }

    public TimeGraph(int range) {
        this.range = range;
        this.boxWidth = 10;
        this.currentTime = 0;
        this.component = null;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new JComponent(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics g) {
                    g.setColor(Color.white);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    for (int i = 0; i < TimeGraph.this.range; ++i) {
                        for (int j = i; j < TimeGraph.this.range; ++j) {
                            if (TimeGraph.this.currentTime % (i + 1) == 0 && TimeGraph.this.currentTime % (j + 1) == 0) {
                                g.setColor(Color.black);
                                g.fillRect(i * TimeGraph.this.boxWidth, j * TimeGraph.this.boxWidth, TimeGraph.this.boxWidth, TimeGraph.this.boxWidth);
                                continue;
                            }
                            g.setColor(Color.gray);
                            g.drawRect(i * TimeGraph.this.boxWidth, j * TimeGraph.this.boxWidth, TimeGraph.this.boxWidth, TimeGraph.this.boxWidth);
                        }
                    }
                    g.setColor(Color.gray);
                    g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            };
            Dimension size = new Dimension(this.range * this.boxWidth + 1, this.range * this.boxWidth + 1);
            this.component.setMinimumSize(size);
            this.component.setPreferredSize(size);
            this.component.setMaximumSize(size);
        }
        return this.component;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    @Override
    public void messageReceived(Bead message) {
        Clock c = (Clock)message;
        if (c.isBeat()) {
            this.currentTime = c.getBeatCount();
            this.component.repaint();
        }
    }
}

