/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.play;

import java.util.ArrayList;
import java.util.List;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.play.Environment;
import net.beadsproject.beads.play.SongGroup;
import net.beadsproject.beads.play.SongPart;
import net.beadsproject.beads.ugens.Clock;

public class GroupPlayer {
    private SongGroup currentGroup = null;
    private SongGroup nextGroup;
    private ArrayList<SongPart> playingParts = new ArrayList();
    private boolean withFadeOut = true;

    public GroupPlayer(Environment e) {
        e.pathways.get("master clock").add(new Bead(){

            @Override
            public void messageReceived(Bead message) {
                Clock c = (Clock)message;
                if (c.isBeat() && GroupPlayer.this.nextGroup != null && c.getBeatCount() % GroupPlayer.this.nextGroup.getFlipQuantisation() == 0) {
                    GroupPlayer.this.doPlayGroupNow(GroupPlayer.this.nextGroup);
                }
            }
        });
    }

    public void playGroup(SongGroup newGroup) {
        this.playGroup(newGroup, true);
    }

    private void playGroup(SongGroup newGroup, boolean withFadeOut) {
        this.withFadeOut = withFadeOut;
        if (newGroup.getFlipQuantisation() < 1) {
            this.doPlayGroupNow(newGroup);
        } else {
            this.nextGroup = newGroup;
        }
    }

    public void playGroupNoFadeOut(SongGroup newGroup) {
        this.playGroup(newGroup, false);
    }

    private void doPlayGroupNow(SongGroup newGroup) {
        if (this.currentGroup != null) {
            ArrayList<SongPart> incoming = new ArrayList<SongPart>();
            ArrayList<SongPart> outgoing = new ArrayList<SongPart>();
            for (SongPart p : this.currentGroup.parts()) {
                if (newGroup.parts().contains(p)) continue;
                outgoing.add(p);
            }
            for (SongPart p : newGroup.parts()) {
                if (this.currentGroup.parts().contains(p)) continue;
                incoming.add(p);
            }
            this.endPlayingList(outgoing);
            this.beginPlayingList(incoming);
        } else {
            this.beginPlayingList(newGroup.parts());
        }
        this.currentGroup = newGroup;
        this.nextGroup = null;
    }

    public void stop() {
        if (this.currentGroup != null) {
            this.endPlayingList(this.currentGroup.parts());
            this.currentGroup = null;
        }
    }

    private void beginPlayingList(List<SongPart> list) {
        for (SongPart p : list) {
            this.beginPlayingPart(p);
        }
    }

    private void beginPlayingPart(SongPart p) {
        p.enter();
        p.pause(false);
        this.playingParts.add(p);
    }

    private void endPlayingList(List<SongPart> list) {
        for (SongPart p : list) {
            this.endPlayingPart(p);
        }
    }

    private void endPlayingPart(SongPart p) {
        if (this.withFadeOut) {
            p.exit();
        } else {
            p.pause(true);
        }
        this.playingParts.remove(p);
    }

    public SongGroup getCurrentGroup() {
        if (this.nextGroup != null) {
            return this.nextGroup;
        }
        return this.currentGroup;
    }

    public void setCurrentGroup(SongGroup currentGroup) {
        this.currentGroup = currentGroup;
    }

    public void notifyCurrentGroupUpdated() {
        if (this.currentGroup != null) {
            for (SongPart p : this.currentGroup.parts()) {
                if (this.playingParts.contains(p)) continue;
                this.beginPlayingPart(p);
            }
            for (SongPart p : (List)this.playingParts.clone()) {
                if (this.currentGroup.contains(p)) continue;
                this.endPlayingPart(p);
            }
        }
    }
}

