/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.play;

import java.util.ArrayList;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.BeadArray;
import net.beadsproject.beads.events.IntegerBead;
import net.beadsproject.beads.play.Pattern;

public class PatternPlayer
extends Bead {
    private Pattern pattern;
    private final BeadArray listeners = new BeadArray();
    private int hop;
    private int loop;
    private ContinuousPlayMode continuousPlayMode = ContinuousPlayMode.EXTERNAL;
    private int currentIndex;
    private ArrayList<Integer> currentValue;

    public PatternPlayer(Pattern pattern) {
        this();
        this.setPattern(pattern);
    }

    public PatternPlayer() {
        this.setHop(1);
        this.setLoop(16);
        this.reset();
    }

    public void addListener(Bead listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Bead listener) {
        this.listeners.remove(listener);
    }

    public ContinuousPlayMode getContinuousPlayMode() {
        return this.continuousPlayMode;
    }

    public void setContinuousPlayMode(ContinuousPlayMode continuousPlayMode) {
        this.continuousPlayMode = continuousPlayMode;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
        int suggestedLoop = pattern.getSuggestedLoop();
        if (suggestedLoop != 0) {
            this.loop = suggestedLoop;
        }
    }

    public int getLastIndex() {
        if (this.continuousPlayMode == ContinuousPlayMode.INTERNAL) {
            if (this.currentIndex == 0) {
                return this.loop - 1;
            }
            return this.currentIndex - 1;
        }
        return this.currentIndex;
    }

    @Override
    public void messageReceived(Bead message) {
        int index = ((IntegerBead)((Object)message)).getInt();
        this.getEventAtStep(index);
        if (this.currentValue != null) {
            this.listeners.message(this);
        }
    }

    public ArrayList<Integer> getEventAtStep(int index) {
        this.currentValue = null;
        if (this.continuousPlayMode == ContinuousPlayMode.INTERNAL) {
            if (index % this.hop == 0) {
                this.currentValue = this.pattern.getEventAtIndex(this.currentIndex);
                ++this.currentIndex;
                if (this.currentIndex >= this.loop) {
                    this.reset();
                }
            }
        } else if (index % this.hop == 0) {
            this.currentIndex = index / this.hop % this.loop;
            this.currentValue = this.pattern.getEventAtIndex(this.currentIndex);
        }
        return this.currentValue;
    }

    public ArrayList<Integer> getEventAtStepQuantized(int index, int quantization) {
        this.currentValue = null;
        if (this.continuousPlayMode == ContinuousPlayMode.INTERNAL) {
            if (index % this.hop == 0) {
                this.currentValue = this.pattern.getQuantizedEvent(this.currentIndex, quantization, this.loop);
                ++this.currentIndex;
                if (this.currentIndex >= this.loop) {
                    this.reset();
                }
            }
        } else if (index % this.hop == 0) {
            this.currentIndex = index / this.hop % this.loop;
            this.currentValue = this.pattern.getQuantizedEvent(this.currentIndex, quantization, this.loop);
        }
        return this.currentValue;
    }

    public void reset() {
        this.currentIndex = 0;
    }

    public int getHop() {
        return this.hop;
    }

    public void setHop(int hop) {
        this.hop = hop;
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        this.loop = loop;
    }

    public void setNoLoop() {
        this.loop = Integer.MAX_VALUE;
    }

    public static enum ContinuousPlayMode {
        INTERNAL,
        EXTERNAL;

    }
}

