/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.play;

import java.awt.Color;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.events.PauseTrigger;
import net.beadsproject.beads.gui.BeadsColors;
import net.beadsproject.beads.gui.BeadsKeys;
import net.beadsproject.beads.gui.BeadsPanel;
import net.beadsproject.beads.gui.LevelMeter;
import net.beadsproject.beads.gui.Slider;
import net.beadsproject.beads.gui.Slider2D;
import net.beadsproject.beads.play.Environment;
import net.beadsproject.beads.play.InterfaceElement;
import net.beadsproject.beads.ugens.Clock;
import net.beadsproject.beads.ugens.Envelope;
import net.beadsproject.beads.ugens.Function;
import net.beadsproject.beads.ugens.Gain;
import net.beadsproject.beads.ugens.Spatial;

public abstract class SongPart
extends Gain
implements InterfaceElement {
    protected ArrayList<InterfaceElement> interfaceElements;
    protected JComponent panel;
    protected int state;
    protected Clock clock;
    protected Gain controllableGain;
    protected Environment environment;
    private Color color;
    private BeadsKeys.KeyboardListener kl;

    public SongPart(String name, Environment environment) {
        this(name, environment, environment.ac.getAudioFormat().outputs, 2);
    }

    protected SongPart(String name, Environment environment, int destChannels, int sourceChannels) {
        super(environment.ac, destChannels);
        this.environment = environment;
        this.setName(name);
        this.pause(true);
        this.state = 0;
        this.color = BeadsColors.nextColor();
        this.interfaceElements = new ArrayList();
        this.interfaceElements.add(new LevelMeter(this));
        Slider s = new Slider(this.context, "gain", 0.0f, 2.0f, 0.2f, true);
        this.interfaceElements.add(s);
        this.controllableGain = new Gain(this.context, sourceChannels);
        this.controllableGain.setGain(s);
        if (destChannels == sourceChannels) {
            this.addInput(this.controllableGain);
        } else {
            this.setupPanner(destChannels, sourceChannels);
        }
        this.setGain(new Envelope(this.context, 0.0f));
        this.kl = new BeadsKeys.KeyboardListener(){

            @Override
            public void keyReleased(int keyCode) {
                if (SongPart.this.panel != null && SongPart.this.panel.getTopLevelAncestor() != null && SongPart.this.panel.getTopLevelAncestor().hasFocus()) {
                    SongPart.this.keyReleased(keyCode);
                }
            }

            @Override
            public void keyPressed(int keyCode) {
                if (SongPart.this.panel != null && SongPart.this.panel.getTopLevelAncestor() != null && SongPart.this.panel.getTopLevelAncestor().hasFocus()) {
                    SongPart.this.keyPressed(keyCode);
                }
            }
        };
        BeadsKeys.addListener(this.kl);
    }

    public void setupPanner(int destChannels, int sourceChannels) {
        if (destChannels == 4) {
            Spatial mixer = new Spatial(this.context, 2);
            this.addInput(mixer);
            UGen[][] positionControllers = new UGen[sourceChannels][2];
            if (sourceChannels == 2) {
                Slider x = new Slider(this.context, "x", 0.0f, 1.0f, 0.5f);
                Slider y = new Slider(this.context, "y", 0.0f, 1.0f, 0.5f);
                Slider2D s2d = new Slider2D(x, y);
                positionControllers[0][0] = new Function((UGen)x){

                    @Override
                    public float calculate() {
                        return this.x[0] - 0.3f;
                    }
                };
                positionControllers[1][0] = new Function((UGen)x){

                    @Override
                    public float calculate() {
                        return this.x[0] + 0.3f;
                    }
                };
                positionControllers[0][1] = y;
                positionControllers[1][1] = y;
                this.interfaceElements.add(s2d);
            } else {
                for (int i = 0; i < sourceChannels; ++i) {
                    Slider x = new Slider(this.context, "x", 0.0f, 1.0f, 0.5f);
                    Slider y = new Slider(this.context, "y", 0.0f, 1.0f, 0.5f);
                    positionControllers[i][0] = x;
                    positionControllers[i][1] = y;
                    Slider2D s2d = new Slider2D(x, y);
                    this.interfaceElements.add(s2d);
                }
            }
            mixer.addInput(this.controllableGain, positionControllers);
        } else if (destChannels == 8) {
            System.err.println("Shizza, I don't know how to deal with 8 channels :-)");
        }
    }

    public void setState(int state) {
        this.state = state;
    }

    private void setupPanel() {
        this.panel = new BeadsPanel();
        ((BeadsPanel)this.panel).coloredLineBorder(this.getColor(), 5);
        for (InterfaceElement p : this.interfaceElements) {
            this.panel.add(p.getComponent());
        }
        if (this instanceof KeyListener) {
            System.out.println("KEY LISTENER");
            this.panel.addKeyListener((KeyListener)((Object)this));
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.panel == null) {
            this.setupPanel();
        }
        return this.panel;
    }

    public void enter() {
        ((Envelope)this.getGainUGen()).lock(false);
        this.getGainUGen().setValue(1.0f);
    }

    public void exit() {
        ((Envelope)this.getGainUGen()).clear();
        ((Envelope)this.getGainUGen()).addSegment(0.0f, 500.0f, new PauseTrigger(this));
        ((Envelope)this.getGainUGen()).lock(true);
    }

    @Override
    public final String toString() {
        return this.getName() + " (" + this.getClass().getSimpleName() + ")";
    }

    @Override
    public void kill() {
        super.kill();
        BeadsKeys.removeListener(this.kl);
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }
}

