/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.UGen;

public class Add
extends UGen {
    private UGen adderUGen;
    private float adder = 0.0f;

    public Add(AudioContext context, int channels, UGen adderUGen) {
        super(context, channels, channels);
        this.setAdder(adderUGen);
    }

    public Add(AudioContext context, UGen input, UGen adderUGen) {
        super(context, input.getOuts(), input.getOuts());
        this.setAdder(adderUGen);
        this.addInput(input);
    }

    public Add(AudioContext context, int channels, float adder) {
        super(context, channels, channels);
        this.setAdder(adder);
    }

    @Override
    public void calculateBuffer() {
        if (this.adderUGen == null) {
            for (int j = 0; j < this.outs; ++j) {
                float[] bi = this.bufIn[j];
                float[] bo = this.bufOut[j];
                for (int i = 0; i < this.bufferSize; ++i) {
                    bo[i] = bi[i] + this.adder;
                }
            }
        } else {
            this.adderUGen.update();
            if (this.outs == 1) {
                float[] bi = this.bufIn[0];
                float[] bo = this.bufOut[0];
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.adder = this.adderUGen.getValue(0, i);
                    bo[i] = bi[i] + this.adder;
                }
            } else {
                for (int i = 0; i < this.bufferSize; ++i) {
                    for (int j = 0; j < this.outs; ++j) {
                        this.adder = this.adderUGen.getValue(0, i);
                        this.bufOut[j][i] = this.bufIn[j][i] + this.adder;
                    }
                }
            }
        }
    }

    public float getAdder() {
        return this.adder;
    }

    public Add setAdder(float adder) {
        this.adder = adder;
        this.adderUGen = null;
        return this;
    }

    public Add setAdder(UGen adderUGen) {
        if (adderUGen == null) {
            this.setAdder(this.adder);
        } else {
            this.adderUGen = adderUGen;
            adderUGen.update();
            this.adder = adderUGen.getValue();
        }
        return this;
    }

    public UGen getAdderUGen() {
        return this.adderUGen;
    }
}

