/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.IIRFilter;
import net.beadsproject.beads.ugens.Static;

public class AllpassFilter
extends IIRFilter
implements DataBeadReceiver {
    protected float g;
    protected int maxDelay = 1;
    protected int delay = 1;
    protected int ind = 0;
    protected int bufLen;
    protected UGen delayUGen;
    protected UGen gUGen;
    protected boolean isDelayStatic;
    protected boolean isGStatic;
    protected float[] xn;
    protected float[] yn;

    public AllpassFilter(AudioContext context, int maxdel, int idel, float ig) {
        this(context, maxdel);
        this.setDelay(idel).setG(ig);
    }

    public AllpassFilter(AudioContext context, int maxdel, UGen idel, float ig) {
        this(context, maxdel);
        this.setDelay(idel).setG(ig);
    }

    public AllpassFilter(AudioContext context, int maxdel, int idel, UGen ig) {
        this(context, maxdel);
        this.setDelay(idel).setG(ig);
    }

    public AllpassFilter(AudioContext context, int maxdel, UGen idel, UGen ig) {
        this(context, maxdel);
        this.setDelay(idel).setG(ig);
    }

    private AllpassFilter(AudioContext context, int maxdel) {
        super(context, 1, 1);
        this.maxDelay = Math.max(maxdel, 1);
        this.bufLen = this.maxDelay + 1;
        this.xn = new float[this.bufLen];
        this.yn = new float[this.bufLen];
    }

    @Override
    public void calculateBuffer() {
        float[] bi = this.bufIn[0];
        float[] bo = this.bufOut[0];
        if (this.isDelayStatic && this.isGStatic) {
            int ind2 = (this.ind + this.bufLen - this.delay) % this.bufLen;
            for (int currsample = 0; currsample < this.bufferSize; ++currsample) {
                this.xn[this.ind] = bi[currsample];
                bo[currsample] = this.yn[this.ind] = this.xn[ind2] + this.g * (this.yn[ind2] - this.xn[this.ind]);
                ind2 = (ind2 + 1) % this.bufLen;
                this.ind = (this.ind + 1) % this.bufLen;
            }
        } else {
            this.gUGen.update();
            this.delayUGen.update();
            for (int currsample = 0; currsample < this.bufferSize; ++currsample) {
                this.delay = (int)this.gUGen.getValue(0, currsample);
                if (this.delay < 1) {
                    this.delay = 1;
                } else if (this.delay > this.maxDelay) {
                    this.delay = this.maxDelay;
                }
                int ind2 = (this.ind + this.bufLen - this.delay) % this.bufLen;
                this.xn[this.ind] = bi[currsample];
                bo[currsample] = this.yn[this.ind] = this.xn[ind2] + this.gUGen.getValue(0, currsample) * (this.yn[ind2] - this.xn[this.ind]);
                this.ind = (this.ind + 1) % this.bufLen;
            }
            this.g = this.gUGen.getValue(0, this.bufferSize - 1);
        }
    }

    public float getG() {
        return this.g;
    }

    public AllpassFilter setG(float g) {
        this.g = g;
        if (this.isGStatic) {
            this.gUGen.setValue(g);
        } else {
            this.gUGen = new Static(this.context, g);
            this.isGStatic = true;
        }
        return this;
    }

    public AllpassFilter setG(UGen g) {
        if (g == null) {
            this.setG(this.g);
        } else {
            this.gUGen = g;
            g.update();
            this.g = g.getValue();
            this.isGStatic = false;
        }
        return this;
    }

    public UGen getGUGen() {
        if (this.isGStatic) {
            return null;
        }
        return this.gUGen;
    }

    public int getDelay() {
        return this.delay;
    }

    public AllpassFilter setDelay(int del) {
        this.delay = del > this.maxDelay ? this.maxDelay : (del < 1 ? 1 : del);
        if (this.isDelayStatic) {
            this.delayUGen.setValue(this.delay);
        } else {
            this.delayUGen = new Static(this.context, (float)this.delay);
            this.isDelayStatic = true;
        }
        return this;
    }

    public AllpassFilter setDelay(UGen del) {
        if (del == null) {
            this.setDelay(this.delay);
        } else {
            this.delayUGen = del;
            del.update();
            this.delay = (int)del.getValue();
            if (this.delay < 0) {
                this.delay = 0;
            } else if (this.delay > this.maxDelay) {
                this.delay = this.maxDelay;
            }
            this.isDelayStatic = false;
        }
        return this;
    }

    public UGen getDelayUGen() {
        if (this.isDelayStatic) {
            return null;
        }
        return this.delayUGen;
    }

    public AllpassFilter setParams(DataBead paramBead) {
        if (paramBead != null) {
            Object o = paramBead.get("delay");
            if (o != null) {
                if (o instanceof UGen) {
                    this.setDelay((UGen)o);
                } else {
                    this.setDelay((int)paramBead.getFloat("delay", this.delay));
                }
            }
            if ((o = paramBead.get("g")) != null) {
                if (o instanceof UGen) {
                    this.setG((UGen)o);
                } else {
                    this.setG(paramBead.getFloat("g", this.g));
                }
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.setParams((DataBead)message);
        }
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        if (this.isDelayStatic) {
            db.put("delay", (Object)this.delay);
        } else {
            db.put("delay", (Object)this.delayUGen);
        }
        if (this.isGStatic) {
            db.put("g", (Object)Float.valueOf(this.g));
        } else {
            db.put("g", (Object)this.gUGen);
        }
        return db;
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("delay", (Object)this.delay);
        db.put("g", (Object)Float.valueOf(this.g));
        return db;
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        this.setParams(db);
        return this;
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float freq) {
        float[] as = new float[this.delay + 1];
        float[] bs = new float[this.delay + 1];
        bs[0] = as[this.delay] = -this.g;
        bs[this.delay] = 1.0f;
        as[0] = 1.0f;
        return AllpassFilter.calculateFilterResponse(bs, as, freq, this.context.getSampleRate());
    }
}

