/*
 * Decompiled with CFR 0.152.
 */
package net.beadsproject.beads.ugens;

import net.beadsproject.beads.core.AudioContext;
import net.beadsproject.beads.core.Bead;
import net.beadsproject.beads.core.UGen;
import net.beadsproject.beads.data.DataBead;
import net.beadsproject.beads.data.DataBeadReceiver;
import net.beadsproject.beads.ugens.IIRFilter;
import net.beadsproject.beads.ugens.Static;

public class BiquadFilter
extends IIRFilter
implements DataBeadReceiver {
    public static final Type LP = Type.LP;
    public static final Type HP = Type.HP;
    public static final Type BP_SKIRT = Type.BP_SKIRT;
    public static final Type BP_PEAK = Type.BP_PEAK;
    public static final Type NOTCH = Type.NOTCH;
    public static final Type AP = Type.AP;
    public static final Type PEAKING_EQ = Type.PEAKING_EQ;
    public static final Type LOW_SHELF = Type.LOW_SHELF;
    public static final Type HIGH_SHELF = Type.HIGH_SHELF;
    public static final Type BUTTERWORTH_LP = Type.BUTTERWORTH_LP;
    public static final Type BUTTERWORTH_HP = Type.BUTTERWORTH_HP;
    public static final Type BESSEL_LP = Type.BESSEL_LP;
    public static final Type BESSEL_HP = Type.BESSEL_HP;
    public static final Type CUSTOM_FILTER = Type.CUSTOM_FILTER;
    protected float a0 = 1.0f;
    protected float a1 = 0.0f;
    protected float a2 = 0.0f;
    protected float b0 = 0.0f;
    protected float b1 = 0.0f;
    protected float b2 = 0.0f;
    protected int channels = super.getOuts();
    protected float freq = 100.0f;
    protected float q = 1.0f;
    protected float gain = 0.0f;
    protected Type type = null;
    protected float samplingfreq;
    protected float two_pi_over_sf;
    protected float pi_over_sf;
    public static final float SQRT2 = (float)Math.sqrt(2.0);
    protected double w = 0.0;
    protected double ampResponse = 0.0;
    protected double phaseResponse = 0.0;
    protected double phaseDelay = 0.0;
    protected double frReal = 0.0;
    protected double frImag = 0.0;
    protected float[] bo1m;
    protected float[] bo2m;
    protected float[] bi1m = new float[this.channels];
    protected float[] bi2m = new float[this.channels];
    protected float bo1 = 0.0f;
    protected float bo2 = 0.0f;
    protected float bi1 = 0.0f;
    protected float bi2 = 0.0f;
    protected boolean cuedInputMemory = false;
    protected boolean cuedOutputMemory = false;
    protected float[] cbo1m;
    protected float[] cbo2m;
    protected float[] cbi1m;
    protected float[] cbi2m;
    protected float cbo1 = 0.0f;
    protected float cbo2 = 0.0f;
    protected float cbi1 = 0.0f;
    protected float cbi2 = 0.0f;
    protected ValCalculator vc;
    protected UGen freqUGen;
    protected UGen qUGen;
    protected UGen gainUGen;
    protected boolean isFreqStatic;
    protected boolean isQStatic;
    protected boolean isGainStatic;
    protected boolean areAllStatic;

    public BiquadFilter(AudioContext context, int channels) {
        this(context, channels, LP);
    }

    public BiquadFilter(AudioContext context, int channels, Type itype) {
        super(context, channels, channels);
        this.bo1m = new float[this.channels];
        this.bo2m = new float[this.channels];
        this.samplingfreq = context.getSampleRate();
        this.two_pi_over_sf = (float)(Math.PI * 2 / (double)this.samplingfreq);
        this.pi_over_sf = (float)(Math.PI / (double)this.samplingfreq);
        this.setType(itype);
        this.setFrequency(this.freq).setQ(this.q).setGain(this.gain);
    }

    public BiquadFilter(AudioContext context, int channels, DataBead params) {
        this(context, channels, LP);
        this.setParams(params);
    }

    public BiquadFilter(AudioContext context, int channels, Type itype, DataBead params) {
        this(context, channels, itype);
        this.setParams(params);
    }

    public BiquadFilter(AudioContext context, Type itype, float ifreq, float iqval) {
        this(context, 1, itype);
        this.setFrequency(ifreq).setQ(iqval);
    }

    public BiquadFilter(AudioContext context, Type itype, UGen ifreq, float iqval) {
        this(context, 1, itype);
        this.setFrequency(ifreq).setQ(iqval);
    }

    public BiquadFilter(AudioContext context, Type itype, float ifreq, UGen iqval) {
        this(context, 1, itype);
        this.setFrequency(ifreq).setQ(iqval);
    }

    public BiquadFilter(AudioContext context, Type itype, UGen ifreq, UGen iqval) {
        this(context, 1, itype);
        this.setFrequency(ifreq).setQ(iqval);
    }

    private void checkStaticStatus() {
        if (this.isFreqStatic && this.isQStatic && this.isGainStatic) {
            this.areAllStatic = true;
            this.vc.calcVals();
        } else {
            this.areAllStatic = false;
        }
    }

    @Override
    public void calculateBuffer() {
        block20: {
            int i;
            block19: {
                if (this.channels != 1) break block19;
                if (this.cuedInputMemory) {
                    this.bi1 = this.cbi1;
                    this.bi2 = this.cbi2;
                    this.cuedInputMemory = false;
                }
                if (this.cuedOutputMemory) {
                    this.bo1 = this.cbo1;
                    this.bo2 = this.cbo2;
                    this.cuedOutputMemory = false;
                }
                float[] bi = this.bufIn[0];
                float[] bo = this.bufOut[0];
                if (this.areAllStatic) {
                    bo[0] = (this.b0 * bi[0] + this.b1 * this.bi1 + this.b2 * this.bi2 - this.a1 * this.bo1 - this.a2 * this.bo2) / this.a0;
                    bo[1] = (this.b0 * bi[1] + this.b1 * bi[0] + this.b2 * this.bi1 - this.a1 * bo[0] - this.a2 * this.bo1) / this.a0;
                    for (int currsamp = 2; currsamp < this.bufferSize; ++currsamp) {
                        bo[currsamp] = (this.b0 * bi[currsamp] + this.b1 * bi[currsamp - 1] + this.b2 * bi[currsamp - 2] - this.a1 * bo[currsamp - 1] - this.a2 * bo[currsamp - 2]) / this.a0;
                    }
                } else {
                    this.freqUGen.update();
                    this.qUGen.update();
                    this.gainUGen.update();
                    this.freq = this.freqUGen.getValue(0, 0);
                    this.q = this.qUGen.getValue(0, 0);
                    this.gain = this.gainUGen.getValue(0, 0);
                    this.vc.calcVals();
                    bo[0] = (this.b0 * bi[0] + this.b1 * this.bi1 + this.b2 * this.bi2 - this.a1 * this.bo1 - this.a2 * this.bo2) / this.a0;
                    this.freq = this.freqUGen.getValue(0, 1);
                    this.q = this.qUGen.getValue(0, 1);
                    this.gain = this.gainUGen.getValue(0, 1);
                    this.vc.calcVals();
                    bo[1] = (this.b0 * bi[1] + this.b1 * bi[0] + this.b2 * this.bi1 - this.a1 * bo[0] - this.a2 * this.bo1) / this.a0;
                    for (int currsamp = 2; currsamp < this.bufferSize; ++currsamp) {
                        this.freq = this.freqUGen.getValue(0, currsamp);
                        this.q = this.qUGen.getValue(0, currsamp);
                        this.gain = this.gainUGen.getValue(0, currsamp);
                        this.vc.calcVals();
                        bo[currsamp] = (this.b0 * bi[currsamp] + this.b1 * bi[currsamp - 1] + this.b2 * bi[currsamp - 2] - this.a1 * bo[currsamp - 1] - this.a2 * bo[currsamp - 2]) / this.a0;
                    }
                }
                this.bi1 = bi[this.bufferSize - 1];
                this.bi2 = bi[this.bufferSize - 2];
                this.bo1 = bo[this.bufferSize - 1];
                this.bo2 = bo[this.bufferSize - 2];
                if (!Float.isNaN(this.bo1)) break block20;
                this.reset();
                break block20;
            }
            if (this.cuedInputMemory) {
                for (i = 0; i < this.channels; ++i) {
                    this.bi1m[i] = this.cbi1m[i];
                    this.bi2m[i] = this.cbi2m[i];
                }
                this.cuedInputMemory = false;
            }
            if (this.cuedOutputMemory) {
                for (i = 0; i < this.channels; ++i) {
                    this.bo1m[i] = this.cbo1m[i];
                    this.bo2m[i] = this.cbo2m[i];
                }
                this.cuedOutputMemory = false;
            }
            if (this.areAllStatic) {
                for (i = 0; i < this.channels; ++i) {
                    float[] bi = this.bufIn[i];
                    float[] bo = this.bufOut[i];
                    bo[0] = (this.b0 * bi[0] + this.b1 * this.bi1m[i] + this.b2 * this.bi2m[i] - this.a1 * this.bo1m[i] - this.a2 * this.bo2m[i]) / this.a0;
                    bo[1] = (this.b0 * bi[1] + this.b1 * bi[0] + this.b2 * this.bi1m[i] - this.a1 * bo[0] - this.a2 * this.bo1m[i]) / this.a0;
                    for (int currsamp = 2; currsamp < this.bufferSize; ++currsamp) {
                        bo[currsamp] = (this.b0 * bi[currsamp] + this.b1 * bi[currsamp - 1] + this.b2 * bi[currsamp - 2] - this.a1 * bo[currsamp - 1] - this.a2 * bo[currsamp - 2]) / this.a0;
                    }
                    this.bi2m[i] = bi[this.bufferSize - 2];
                    this.bi1m[i] = bi[this.bufferSize - 1];
                    this.bo2m[i] = bo[this.bufferSize - 2];
                    this.bo1m[i] = bo[this.bufferSize - 1];
                    if (!Float.isNaN(this.bo1m[i])) continue;
                    this.reset();
                }
            } else {
                this.freqUGen.update();
                this.qUGen.update();
                this.gainUGen.update();
                this.freq = this.freqUGen.getValue(0, 0);
                this.q = this.qUGen.getValue(0, 0);
                this.gain = this.gainUGen.getValue(0, 0);
                this.vc.calcVals();
                for (i = 0; i < this.channels; ++i) {
                    this.bufOut[i][0] = (this.b0 * this.bufIn[i][0] + this.b1 * this.bi1m[i] + this.b2 * this.bi2m[i] - this.a1 * this.bo1m[i] - this.a2 * this.bo2m[i]) / this.a0;
                }
                this.freq = this.freqUGen.getValue(0, 1);
                this.q = this.qUGen.getValue(0, 1);
                this.gain = this.gainUGen.getValue(0, 1);
                this.vc.calcVals();
                for (i = 0; i < this.channels; ++i) {
                    this.bufOut[i][1] = (this.b0 * this.bufIn[i][1] + this.b1 * this.bufIn[i][0] + this.b2 * this.bi1m[i] - this.a1 * this.bufOut[i][0] - this.a2 * this.bo1m[i]) / this.a0;
                }
                for (int currsamp = 2; currsamp < this.bufferSize; ++currsamp) {
                    this.freq = this.freqUGen.getValue(0, currsamp);
                    this.q = this.qUGen.getValue(0, currsamp);
                    this.gain = this.gainUGen.getValue(0, currsamp);
                    this.vc.calcVals();
                    for (int i2 = 0; i2 < this.channels; ++i2) {
                        this.bufOut[i2][currsamp] = (this.b0 * this.bufIn[i2][currsamp] + this.b1 * this.bufIn[i2][currsamp - 1] + this.b2 * this.bufIn[i2][currsamp - 2] - this.a1 * this.bufOut[i2][currsamp - 1] - this.a2 * this.bufOut[i2][currsamp - 2]) / this.a0;
                    }
                }
                for (i = 0; i < this.channels; ++i) {
                    this.bi2m[i] = this.bufIn[i][this.bufferSize - 2];
                    this.bi1m[i] = this.bufIn[i][this.bufferSize - 1];
                    this.bo2m[i] = this.bufOut[i][this.bufferSize - 2];
                    this.bo1m[i] = this.bufOut[i][this.bufferSize - 1];
                    if (!Float.isNaN(this.bo1m[i])) continue;
                    this.reset();
                }
            }
        }
    }

    public void reset() {
        for (int i = 0; i < this.channels; ++i) {
            this.bi1m[i] = 0.0f;
            this.bi2m[i] = 0.0f;
            this.bo1m[i] = 0.0f;
            this.bo2m[i] = 0.0f;
        }
        this.bi1 = 0.0f;
        this.bi2 = 0.0f;
        this.bo1 = 0.0f;
        this.bo2 = 0.0f;
    }

    public BiquadFilter setParams(DataBead paramBead) {
        if (paramBead != null) {
            Object o = paramBead.get("type");
            if (o instanceof Number) {
                this.setType(((Number)o).intValue());
            } else if (o instanceof Type) {
                this.setType((Type)((Object)o));
            }
            o = paramBead.get("frequency");
            if (o != null) {
                if (o instanceof UGen) {
                    this.setFrequency((UGen)o);
                } else {
                    this.setFrequency(paramBead.getFloat("frequency", this.freq));
                }
            }
            if ((o = paramBead.get("q")) != null) {
                if (o instanceof UGen) {
                    this.setQ((UGen)o);
                } else {
                    this.setQ(paramBead.getFloat("q", this.q));
                }
            }
            if ((o = paramBead.get("gain")) != null) {
                if (o instanceof UGen) {
                    this.setGain((UGen)o);
                } else {
                    this.setGain(paramBead.getFloat("gain", this.gain));
                }
            }
        }
        return this;
    }

    @Override
    public void messageReceived(Bead message) {
        if (message instanceof DataBead) {
            this.setParams((DataBead)message);
        }
    }

    @Override
    public DataBeadReceiver sendData(DataBead db) {
        this.setParams(db);
        return this;
    }

    public DataBead getParams() {
        DataBead db = new DataBead();
        if (this.isFreqStatic) {
            db.put("frequency", (Object)Float.valueOf(this.freq));
        } else {
            db.put("frequency", (Object)this.freqUGen);
        }
        if (this.isQStatic) {
            db.put("q", (Object)Float.valueOf(this.q));
        } else {
            db.put("q", (Object)this.qUGen);
        }
        if (this.isGainStatic) {
            db.put("gain", (Object)Float.valueOf(this.gain));
        } else {
            db.put("gain", (Object)this.gainUGen);
        }
        db.put("type", (Object)this.type);
        return db;
    }

    public DataBead getStaticParams() {
        DataBead db = new DataBead();
        db.put("frequency", (Object)Float.valueOf(this.freq));
        db.put("q", (Object)Float.valueOf(this.q));
        db.put("gain", (Object)Float.valueOf(this.gain));
        db.put("type", (Object)this.type);
        return db;
    }

    public BiquadFilter setType(Type ntype) {
        if (ntype != this.type || this.vc == null) {
            Type t = this.type;
            this.type = ntype;
            switch (this.type) {
                case LP: {
                    this.vc = new LPValCalculator();
                    break;
                }
                case HP: {
                    this.vc = new HPValCalculator();
                    break;
                }
                case BP_SKIRT: {
                    this.vc = new BPSkirtValCalculator();
                    break;
                }
                case BP_PEAK: {
                    this.vc = new BPPeakValCalculator();
                    break;
                }
                case NOTCH: {
                    this.vc = new NotchValCalculator();
                    break;
                }
                case AP: {
                    this.vc = new APValCalculator();
                    break;
                }
                case PEAKING_EQ: {
                    this.vc = new PeakingEQValCalculator();
                    break;
                }
                case LOW_SHELF: {
                    this.vc = new LowShelfValCalculator();
                    break;
                }
                case HIGH_SHELF: {
                    this.vc = new HighShelfValCalculator();
                    break;
                }
                case BUTTERWORTH_LP: {
                    this.vc = new ButterworthLPValCalculator();
                    break;
                }
                case BUTTERWORTH_HP: {
                    this.vc = new ButterworthHPValCalculator();
                    break;
                }
                case BESSEL_LP: {
                    this.vc = new BesselLPValCalculator();
                    break;
                }
                case BESSEL_HP: {
                    this.vc = new BesselHPValCalculator();
                    break;
                }
                default: {
                    this.type = t;
                }
            }
            this.vc.calcVals();
        }
        return this;
    }

    @Deprecated
    public BiquadFilter setType(int ntype) {
        Type n = null;
        switch (ntype) {
            case 0: {
                n = LP;
                break;
            }
            case 1: {
                n = HP;
                break;
            }
            case 2: {
                n = BP_SKIRT;
                break;
            }
            case 3: {
                n = BP_PEAK;
                break;
            }
            case 4: {
                n = NOTCH;
                break;
            }
            case 5: {
                n = AP;
                break;
            }
            case 6: {
                n = PEAKING_EQ;
                break;
            }
            case 7: {
                n = LOW_SHELF;
                break;
            }
            case 8: {
                n = HIGH_SHELF;
                break;
            }
            case 9: {
                n = BUTTERWORTH_LP;
                break;
            }
            case 10: {
                n = BUTTERWORTH_HP;
                break;
            }
            case 11: {
                n = BESSEL_LP;
                break;
            }
            case 12: {
                n = BESSEL_HP;
                break;
            }
            case 100: {
                n = CUSTOM_FILTER;
            }
        }
        if (n != this.type || this.vc == null) {
            Type t = this.type;
            this.type = n;
            switch (this.type) {
                case LP: {
                    this.vc = new LPValCalculator();
                    break;
                }
                case HP: {
                    this.vc = new HPValCalculator();
                    break;
                }
                case BP_SKIRT: {
                    this.vc = new BPSkirtValCalculator();
                    break;
                }
                case BP_PEAK: {
                    this.vc = new BPPeakValCalculator();
                    break;
                }
                case NOTCH: {
                    this.vc = new NotchValCalculator();
                    break;
                }
                case AP: {
                    this.vc = new APValCalculator();
                    break;
                }
                case PEAKING_EQ: {
                    this.vc = new PeakingEQValCalculator();
                    break;
                }
                case LOW_SHELF: {
                    this.vc = new LowShelfValCalculator();
                    break;
                }
                case HIGH_SHELF: {
                    this.vc = new HighShelfValCalculator();
                    break;
                }
                case BUTTERWORTH_LP: {
                    this.vc = new ButterworthLPValCalculator();
                    break;
                }
                case BUTTERWORTH_HP: {
                    this.vc = new ButterworthHPValCalculator();
                    break;
                }
                case BESSEL_LP: {
                    this.vc = new BesselLPValCalculator();
                    break;
                }
                case BESSEL_HP: {
                    this.vc = new BesselHPValCalculator();
                    break;
                }
                default: {
                    this.type = t;
                }
            }
            this.vc.calcVals();
        }
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public float getFrequency() {
        return this.freq;
    }

    public BiquadFilter setFrequency(float freq) {
        this.freq = freq;
        if (this.isFreqStatic) {
            this.freqUGen.setValue(freq);
        } else {
            this.freqUGen = new Static(this.context, freq);
            this.isFreqStatic = true;
            this.checkStaticStatus();
        }
        this.vc.calcVals();
        return this;
    }

    public BiquadFilter setFrequency(UGen freqUGen) {
        if (freqUGen == null) {
            this.setFrequency(this.freq);
        } else {
            this.freqUGen = freqUGen;
            freqUGen.update();
            this.freq = freqUGen.getValue();
            this.isFreqStatic = false;
            this.areAllStatic = false;
        }
        this.vc.calcVals();
        return this;
    }

    public UGen getFrequencyUGen() {
        if (this.isFreqStatic) {
            return null;
        }
        return this.freqUGen;
    }

    @Deprecated
    public float getFreq() {
        return this.getFrequency();
    }

    @Deprecated
    public BiquadFilter setFreq(float freq) {
        return this.setFrequency(freq);
    }

    @Deprecated
    public BiquadFilter setFreq(UGen freqUGen) {
        return this.setFrequency(freqUGen);
    }

    @Deprecated
    public UGen getFreqUGen() {
        return this.getFrequencyUGen();
    }

    public BiquadFilter setQ(float nqval) {
        this.q = nqval;
        if (this.isQStatic) {
            this.qUGen.setValue(nqval);
        } else {
            this.qUGen = new Static(this.context, nqval);
            this.isQStatic = true;
            this.checkStaticStatus();
        }
        this.vc.calcVals();
        return this;
    }

    public BiquadFilter setQ(UGen nqval) {
        if (nqval == null) {
            this.setQ(this.q);
        } else {
            this.qUGen = nqval;
            this.qUGen.update();
            this.q = this.freqUGen.getValue();
            this.isQStatic = false;
            this.areAllStatic = false;
        }
        this.vc.calcVals();
        return this;
    }

    public float getQ() {
        return this.q;
    }

    public UGen getQUGen() {
        if (this.isQStatic) {
            return null;
        }
        return this.qUGen;
    }

    public BiquadFilter setGain(float ngain) {
        this.gain = ngain;
        if (this.isGainStatic) {
            this.gainUGen.setValue(ngain);
        } else {
            this.gainUGen = new Static(this.context, ngain);
            this.isGainStatic = true;
            this.checkStaticStatus();
        }
        this.vc.calcVals();
        return this;
    }

    public BiquadFilter setGain(UGen ngain) {
        if (ngain == null) {
            this.setGain(this.gain);
        } else {
            this.gainUGen = ngain;
            this.gainUGen.update();
            this.gain = this.freqUGen.getValue();
            this.isGainStatic = false;
            this.areAllStatic = false;
        }
        this.vc.calcVals();
        return this;
    }

    public float getGain() {
        return this.gain;
    }

    public UGen getGainUGen() {
        if (this.isGainStatic) {
            return null;
        }
        return this.gainUGen;
    }

    public BiquadFilter loadMemory(float xm1, float xm2, float ym1, float ym2) {
        this.loadInputMemory(xm1, xm2);
        this.loadOutputMemory(ym1, ym2);
        return this;
    }

    public BiquadFilter loadMemory(float[] xm1, float[] xm2, float[] ym1, float[] ym2) {
        this.loadInputMemory(xm1, xm2);
        this.loadOutputMemory(ym1, ym2);
        return this;
    }

    public BiquadFilter loadInputMemory(float xm1, float xm2) {
        if (this.channels == 1) {
            this.bi1 = xm1;
            this.bi2 = xm2;
        } else {
            for (int i = 0; i < this.channels; ++i) {
                this.bi1m[i] = xm1;
                this.bi2m[i] = xm2;
            }
        }
        this.cuedInputMemory = true;
        return this;
    }

    public BiquadFilter loadInputMemory(float[] xm1, float[] xm2) {
        int min = Math.min(xm1.length, xm2.length);
        if (this.channels == 1 && min > 0) {
            this.bi1 = xm1[0];
            this.bi2 = xm2[0];
            this.cuedInputMemory = true;
        } else {
            for (int i = 0; i < Math.min(this.channels, min); ++i) {
                this.cbi1m[i] = xm1[i];
                this.cbi2m[i] = xm2[i];
                this.cuedInputMemory = true;
            }
        }
        return this;
    }

    public BiquadFilter loadOutputMemory(float ym1, float ym2) {
        if (this.channels == 1) {
            this.cbo1 = ym1;
            this.cbo2 = ym2;
        } else {
            for (int i = 0; i < this.channels; ++i) {
                this.cbo1m[i] = ym1;
                this.cbo2m[i] = ym2;
            }
        }
        this.cuedOutputMemory = true;
        return this;
    }

    public BiquadFilter loadOutputMemory(float[] ym1, float[] ym2) {
        int min = Math.min(ym1.length, ym2.length);
        if (this.channels == 1 && min > 0) {
            this.bo1 = ym1[0];
            this.bo2 = ym2[0];
            this.cuedOutputMemory = true;
        } else {
            for (int i = 0; i < Math.min(this.channels, min); ++i) {
                this.bo1m[i] = ym1[i];
                this.bo2m[i] = ym2[i];
                this.cuedOutputMemory = true;
            }
        }
        return this;
    }

    public float[] getCoefficients() {
        return new float[]{this.a0, this.a1, this.a2, this.b0, this.b1, this.b2};
    }

    @Override
    public IIRFilter.IIRFilterAnalysis getFilterResponse(float freq) {
        return BiquadFilter.calculateFilterResponse(new float[]{this.b0, this.b1, this.b2}, new float[]{this.a0, this.a1, this.a2}, freq, this.samplingfreq);
    }

    public BiquadFilter setCustomType(CustomCoeffCalculator cc) {
        this.vc = new CustomValCalculator(cc);
        this.vc.calcVals();
        return this;
    }

    public class CustomCoeffCalculator {
        public float a0 = 1.0f;
        public float a1 = 0.0f;
        public float a2 = 0.0f;
        public float b0 = 0.0f;
        public float b1 = 0.0f;
        public float b2 = 0.0f;
        protected float sampFreq;
        protected float two_pi_over_sf;

        CustomCoeffCalculator(float sf) {
            this.setSamplingFrequency(sf);
        }

        CustomCoeffCalculator() {
            this.setSamplingFrequency(44100.0f);
        }

        public void setSamplingFrequency(float sf) {
            this.sampFreq = sf;
            this.two_pi_over_sf = (float)(Math.PI * 2 / (double)sf);
        }

        public void calcCoeffs(float freq, float q, float gain) {
        }
    }

    private class CustomValCalculator
    extends ValCalculator {
        CustomCoeffCalculator ccc;

        CustomValCalculator(CustomCoeffCalculator iccc) {
            this.ccc = iccc;
        }

        @Override
        public void calcVals() {
            this.ccc.calcCoeffs(BiquadFilter.this.freq, BiquadFilter.this.q, BiquadFilter.this.gain);
            BiquadFilter.this.a0 = this.ccc.a0;
            BiquadFilter.this.a1 = this.ccc.a1;
            BiquadFilter.this.a2 = this.ccc.a2;
            BiquadFilter.this.b0 = this.ccc.b0;
            BiquadFilter.this.b1 = this.ccc.b1;
            BiquadFilter.this.b2 = this.ccc.b2;
        }
    }

    private class BesselHPValCalculator
    extends ValCalculator {
        private BesselHPValCalculator() {
        }

        @Override
        public void calcVals() {
            float w = (float)Math.tan(BiquadFilter.this.pi_over_sf * BiquadFilter.this.freq);
            float w2 = w * w;
            BiquadFilter.this.b0 = 3.0f;
            BiquadFilter.this.b2 = 3.0f;
            BiquadFilter.this.b1 = -6.0f;
            BiquadFilter.this.a0 = w2 + 3.0f * w + 3.0f;
            BiquadFilter.this.a1 = 2.0f * w2 - 6.0f;
            BiquadFilter.this.a2 = w2 - 3.0f * w + 3.0f;
        }
    }

    private class BesselLPValCalculator
    extends ValCalculator {
        private BesselLPValCalculator() {
        }

        @Override
        public void calcVals() {
            float w = (float)Math.tan(BiquadFilter.this.pi_over_sf * BiquadFilter.this.freq);
            BiquadFilter.this.b2 = BiquadFilter.this.b0 = 3.0f * w * w;
            BiquadFilter.this.b1 = 2.0f * BiquadFilter.this.b0;
            BiquadFilter.this.a0 = 1.0f + 3.0f * w + BiquadFilter.this.b0;
            BiquadFilter.this.a1 = -2.0f + BiquadFilter.this.b1;
            BiquadFilter.this.a2 = 1.0f - 3.0f * w + BiquadFilter.this.b0;
        }
    }

    private class ButterworthBPValCalculator
    extends ValCalculator {
        private ButterworthBPValCalculator() {
        }

        @Override
        public void calcVals() {
            float hbw = BiquadFilter.this.pi_over_sf * 0.5f * BiquadFilter.this.freq / BiquadFilter.this.q;
            float root = (float)Math.sqrt(1.0f + 4.0f * BiquadFilter.this.q * BiquadFilter.this.q);
            float k1 = (float)Math.tan(hbw * (root - 1.0f));
            float k2 = (float)Math.tan(hbw * (root + 1.0f));
            float mp1 = k1 * k2 + 1.0f;
            BiquadFilter.this.b0 = k2 - k1;
            BiquadFilter.this.b2 = -BiquadFilter.this.b0;
            BiquadFilter.this.b1 = 0.0f;
            BiquadFilter.this.a0 = mp1 + BiquadFilter.this.b0;
            BiquadFilter.this.a1 = 2.0f * (mp1 - 2.0f);
            BiquadFilter.this.a2 = mp1 - BiquadFilter.this.b0;
        }
    }

    private class ButterworthHPValCalculator
    extends ValCalculator {
        private ButterworthHPValCalculator() {
        }

        @Override
        public void calcVals() {
            float k = (float)Math.tan(BiquadFilter.this.freq * BiquadFilter.this.pi_over_sf);
            float k2p1 = k * k + 1.0f;
            BiquadFilter.this.b2 = 1.0f;
            BiquadFilter.this.b0 = 1.0f;
            BiquadFilter.this.b1 = -2.0f;
            BiquadFilter.this.a0 = k2p1 + SQRT2 * k;
            BiquadFilter.this.a1 = 2.0f * (k2p1 - 2.0f);
            BiquadFilter.this.a2 = k2p1 - SQRT2 * k;
        }
    }

    private class ButterworthLPValCalculator
    extends ValCalculator {
        private ButterworthLPValCalculator() {
        }

        @Override
        public void calcVals() {
            float k = (float)Math.tan(BiquadFilter.this.freq * BiquadFilter.this.pi_over_sf);
            BiquadFilter.this.b0 = BiquadFilter.this.b2 = k * k;
            BiquadFilter.this.b1 = 2.0f * BiquadFilter.this.b0;
            BiquadFilter.this.a0 = BiquadFilter.this.b0 + SQRT2 * k + 1.0f;
            BiquadFilter.this.a1 = 2.0f * (BiquadFilter.this.b0 - 1.0f);
            BiquadFilter.this.a2 = BiquadFilter.this.b0 - SQRT2 * k + 1.0f;
        }
    }

    private class HighShelfValCalculator
    extends ValCalculator {
        private HighShelfValCalculator() {
        }

        @Override
        public void calcVals() {
            float A = (float)Math.pow(10.0, (double)BiquadFilter.this.gain * 0.025);
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float cosw = (float)Math.cos(w);
            float a = (float)(Math.sin(w) / (double)BiquadFilter.this.q * 0.5);
            float b = 2.0f * a * (float)Math.sqrt(A);
            float c = (A - 1.0f) * cosw;
            BiquadFilter.this.b0 = A * (A + 1.0f + c + b);
            BiquadFilter.this.b1 = -2.0f * A * (A - 1.0f + (A + 1.0f) * cosw);
            BiquadFilter.this.b2 = A * (A + 1.0f + c - b);
            BiquadFilter.this.a0 = A + 1.0f - c + b;
            BiquadFilter.this.a1 = 2.0f * (A - 1.0f - (A + 1.0f) * cosw);
            BiquadFilter.this.a2 = A + 1.0f - c - b;
        }
    }

    private class LowShelfValCalculator
    extends ValCalculator {
        private LowShelfValCalculator() {
        }

        @Override
        public void calcVals() {
            float A = (float)Math.pow(10.0, (double)BiquadFilter.this.gain * 0.025);
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float cosw = (float)Math.cos(w);
            float a = (float)(Math.sin(w) / (double)BiquadFilter.this.q * 0.5);
            float b = 2.0f * a * (float)Math.sqrt(A);
            float c = (A - 1.0f) * cosw;
            BiquadFilter.this.b0 = A * (A + 1.0f - c + b);
            BiquadFilter.this.b1 = 2.0f * A * (A - 1.0f - (A + 1.0f) * cosw);
            BiquadFilter.this.b2 = A * (A + 1.0f - c - b);
            BiquadFilter.this.a0 = A + 1.0f + c + b;
            BiquadFilter.this.a1 = -2.0f * (A - 1.0f + (A + 1.0f) * cosw);
            BiquadFilter.this.a2 = A + 1.0f + c - b;
        }
    }

    private class PeakingEQValCalculator
    extends ValCalculator {
        private PeakingEQValCalculator() {
        }

        @Override
        public void calcVals() {
            float A = (float)Math.pow(10.0, (double)BiquadFilter.this.gain * 0.025);
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float a = (float)(Math.sin(w) / (double)BiquadFilter.this.q * 0.5);
            BiquadFilter.this.b0 = 1.0f + a * A;
            BiquadFilter.this.b2 = 2.0f - BiquadFilter.this.b0;
            BiquadFilter.this.a1 = BiquadFilter.this.b1 = -2.0f * (float)Math.cos(w);
            BiquadFilter.this.a0 = 1.0f + a / A;
            BiquadFilter.this.a2 = 2.0f - BiquadFilter.this.a0;
        }
    }

    private class APValCalculator
    extends ValCalculator {
        private APValCalculator() {
        }

        @Override
        public void calcVals() {
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float a = (float)(Math.sin(w) / (double)BiquadFilter.this.q * 0.5);
            BiquadFilter.this.a2 = BiquadFilter.this.b0 = 1.0f - a;
            BiquadFilter.this.a1 = BiquadFilter.this.b1 = (float)(-2.0 * Math.cos(w));
            BiquadFilter.this.a0 = BiquadFilter.this.b2 = 1.0f + a;
        }
    }

    private class NotchValCalculator
    extends ValCalculator {
        private NotchValCalculator() {
        }

        @Override
        public void calcVals() {
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float a = (float)Math.sin(w) / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b0 = 1.0f;
            BiquadFilter.this.b2 = 1.0f;
            BiquadFilter.this.a1 = BiquadFilter.this.b1 = -2.0f * (float)Math.cos(w);
            BiquadFilter.this.a0 = 1.0f + a;
            BiquadFilter.this.a2 = 1.0f - a;
        }
    }

    private class BPPeakValCalculator
    extends ValCalculator {
        private BPPeakValCalculator() {
        }

        @Override
        public void calcVals() {
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            BiquadFilter.this.b1 = 0.0f;
            BiquadFilter.this.b0 = (float)Math.sin(w) / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b2 = 0.0f - BiquadFilter.this.b0;
            BiquadFilter.this.a0 = 1.0f + BiquadFilter.this.b0;
            BiquadFilter.this.a1 = -2.0f * (float)Math.cos(w);
            BiquadFilter.this.a2 = 1.0f - BiquadFilter.this.b0;
        }
    }

    private class BPSkirtValCalculator
    extends ValCalculator {
        private BPSkirtValCalculator() {
        }

        @Override
        public void calcVals() {
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float sinw = (float)Math.sin(w);
            float a = sinw / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b1 = 0.0f;
            BiquadFilter.this.b0 = sinw * 0.5f;
            BiquadFilter.this.b2 = 0.0f - BiquadFilter.this.b0;
            BiquadFilter.this.a0 = 1.0f + a;
            BiquadFilter.this.a1 = -2.0f * (float)Math.cos(w);
            BiquadFilter.this.a2 = 1.0f - a;
        }
    }

    private class HPValCalculator
    extends ValCalculator {
        private HPValCalculator() {
        }

        @Override
        public void calcVals() {
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float cosw = (float)Math.cos(w);
            float a = (float)Math.sin(w) / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b1 = -1.0f - cosw;
            BiquadFilter.this.b2 = BiquadFilter.this.b0 = BiquadFilter.this.b1 * -0.5f;
            BiquadFilter.this.a0 = 1.0f + a;
            BiquadFilter.this.a1 = -2.0f * cosw;
            BiquadFilter.this.a2 = 1.0f - a;
        }
    }

    private class LPValCalculator
    extends ValCalculator {
        private LPValCalculator() {
        }

        @Override
        public void calcVals() {
            float w = BiquadFilter.this.two_pi_over_sf * BiquadFilter.this.freq;
            float cosw = (float)Math.cos(w);
            float a = (float)Math.sin(w) / BiquadFilter.this.q * 0.5f;
            BiquadFilter.this.b1 = 1.0f - cosw;
            BiquadFilter.this.b2 = BiquadFilter.this.b0 = BiquadFilter.this.b1 * 0.5f;
            BiquadFilter.this.a0 = 1.0f + a;
            BiquadFilter.this.a1 = -2.0f * cosw;
            BiquadFilter.this.a2 = 1.0f - a;
        }
    }

    protected class ValCalculator {
        protected ValCalculator() {
        }

        public void calcVals() {
        }
    }

    public static enum Type {
        LP,
        HP,
        BP_PEAK,
        BP_SKIRT,
        NOTCH,
        AP,
        PEAKING_EQ,
        LOW_SHELF,
        HIGH_SHELF,
        BUTTERWORTH_LP,
        BUTTERWORTH_HP,
        BESSEL_LP,
        BESSEL_HP,
        CUSTOM_FILTER;

    }
}

